% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_var.R
\name{copy_var}
\alias{copy_var}
\title{Copy a Data Frame Variable and its Value labels to Another Variable}
\usage{
copy_var(data, from.var, to.var, force = FALSE)
}
\arguments{
\item{data}{a data.frame to which variable value labels will be added.}

\item{from.var}{the unquoted name of the variable whose values and labels will
be assigned to the to.var. This variable must presently exist in the data.frame.}

\item{to.var}{the unquoted name of the variable to which the from.var's values
and labels will be assigned. If force = FALSE, this must be a new variable name
(one that does not refer to a variable that already exists in the data.frame).}

\item{force}{if to.var already exists in the data.frame, allow it to be
overwritten. If FALSE, this will not be allowed, and an error will be issued.}
}
\value{
A data.frame.
}
\description{
Note: \code{copy_var} copies an existing variable and its value labels from a
data.frame to another new or (if force = TRUE) existing variable of the
data.frame.
}
\details{
Any non-labelr R operation that changes a variable's (column's) name or that
copies its contents to another variable (column) with a different name will
not associate the original variable's value labels with the new variable name.
To mitigate this, \code{copy_var} allows one to copy both a variable (column) and
its value labels and assign those to another variable.
}
\examples{
# make toy demographic (gender, raceth, etc.) data set
set.seed(555)
df <- make_demo_data(n = 1000) # another labelr:: function
# let's add variable VALUE labels for variable "raceth"
df <- add_val_labs(df,
  vars = "raceth", vals = c(1:7),
  labs = c("White", "Black", "Hispanic", "Asian", "AIAN", "Multi", "Other"),
  max.unique.vals = 50
)

head(df, 4)
df <- copy_var(df, from.var = raceth, to.var = re_copy)
df <- copy_var(df, from.var = x1, to.var = var1)
head(df, 4)
get_val_labs(df)
}
