% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scbind.R
\name{scbind}
\alias{scbind}
\title{Safely Combine Data Frames Column-wise}
\usage{
scbind(...)
}
\arguments{
\item{...}{data.frames to be column-bound}
}
\value{
a data.frame.
}
\description{
\code{scbind} allows one to bind columns together into a data.frame, while
preserving any labelr labels of the inputted data.frames.
}
\details{
Precedence is given to the labels of earlier-appearing arguments, such that,
if both an earlier and a later data.frame include a label attribute with the
same name, the attribute from the earlier data.frame will be preserved, and
the same-named attribute later data.frame(s) will be discarded.
}
\examples{
# assign mtcars to df
df <- mtcars

# add value labels to "am"
df <- add_val_labs(
  data = df,
  vars = "am",
  vals = c(0, 1),
  labs = c("automatic", "manual")
)

# add numerical range value labels to "mpg"
df <- add_quant1(df, mpg, qtiles = 4)

df_a <- sselect(df, "am")
df_b <- sselect(df, "mpg")
df_c <- sselect(mtcars, "cyl")
df_all <- scbind(df_a, df_b, df_c)

head(df_all)

get_val_labs(df_all)
}
