\name{replaceTail}
\alias{replaceOut}
\alias{replaceTail}
\alias{replaceTail.paretoTail}
\title{Replace observations under a Pareto model}
\usage{
  replaceTail(x, ...)

  \method{replaceTail}{paretoTail} (x, all = TRUE, ...)

  replaceOut(x, ...)
}
\arguments{
  \item{x}{an object of class \code{"paretoTail"} (see
  \code{\link{paretoTail}}).}

  \item{all}{a logical indicating whether all observations
  in the upper tail should be replaced or only those
  flagged as outliers.}

  \item{\dots}{additional arguments to be passed down.}
}
\value{
  A numeric vector consisting mostly of the original
  values, but with observations in the upper tail replaced
  with values from the fitted Pareto distribution.
}
\description{
  Replace observations under a Pareto model for the upper
  tail with values drawn from the fitted distribution.
}
\details{
  \code{replaceOut(x, \dots{})} is a simple wrapper for
  \code{replaceTail(x, all = FALSE, \dots{})}.
}
\examples{
data(eusilc)


## gini coefficient without Pareto tail modeling
gini("eqIncome", weights = "rb050", data = eusilc)


## gini coefficient with Pareto tail modeling

# estimate threshold
ts <- paretoScale(eusilc$eqIncome, w = eusilc$db090,
    groups = eusilc$db030)

# estimate shape parameter
fit <- paretoTail(eusilc$eqIncome, k = ts$k,
    w = eusilc$db090, groups = eusilc$db030)

# replacement of outliers
eqIncome <- replaceOut(fit)
gini(eqIncome, weights = eusilc$rb050)

# replacement of whole tail
eqIncome <- replaceTail(fit)
gini(eqIncome, weights = eusilc$rb050)
}
\author{
  Andreas Alfons
}
\references{
  A. Alfons, M. Templ, P. Filzmoser (2013) Robust
  estimation of economic indicators from survey samples
  based on Pareto tail modeling. \emph{Journal of the Royal
  Statistical Society, Series C}, \bold{62}(2), 271--286.
}
\seealso{
  \code{\link{paretoTail}}, \code{\link{reweightOut}},
  \code{\link{shrinkOut}}
}
\keyword{manip}

