% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_adjacencies.R
\name{get_adjacencies}
\alias{get_adjacencies}
\title{get_adjacencies}
\usage{
get_adjacencies(landscape, neighbourhood = 4, what = "full",
  upper = FALSE)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{neighbourhood}{The number of directions in which cell adjacencies are
considered as neighbours: 4 (rook's case), 8 (queen's case) or a binary matrix
where 1 define the neighbourhood and 0 the focal cell. The default is 4.}

\item{what}{Which adjacencies to calculate: "full" for a full adjacency matrix,
"like" for the diagonal, "unlike" for the off diagonal part of the matrix and
"triangle" for a triangular matrix counting adjacencies only once.}

\item{upper}{Logical value indicating whether the upper triangle of the adjacency matrix
should be returned (default FALSE).}
}
\value{
matrix with adjacencies between classes in a raster and between cells from the same class.
}
\description{
Fast calculation of adjacencies between classes in a raster
}
\details{
A fast implementation with Rcpp to calculate the adjacency matrix for raster.
The adjacency matrix is most often used in landscape metrics to describe
the configuration of landscapes, is it is a cellwise count of edges between classes.

The "full" adjacency matrix is double-count method, as it contains the pairwise
counts of cells between all classes. The diagonal of this matrix contains the
like adjacencies, a count for how many edges a shared in each class with the same class.

The "unlike" adjacencies are counting the cellwise edges between different classes.
}
\examples{
# calculate full adjacency matrix
get_adjacencies(landscape, neighbourhood = 4)

}
