% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_tca.R
\name{lsm_c_tca}
\alias{lsm_c_tca}
\alias{lsm_c_tca.RasterLayer}
\alias{lsm_c_tca.RasterStack}
\alias{lsm_c_tca.RasterBrick}
\alias{lsm_c_tca.stars}
\alias{lsm_c_tca.list}
\title{TCA (class level)}
\usage{
lsm_c_tca(landscape, directions, consider_boundary, edge_depth)

\method{lsm_c_tca}{RasterLayer}(landscape, directions = 8, consider_boundary = FALSE, edge_depth = 1)

\method{lsm_c_tca}{RasterStack}(landscape, directions = 8, consider_boundary = FALSE, edge_depth = 1)

\method{lsm_c_tca}{RasterBrick}(landscape, directions = 8, consider_boundary = FALSE, edge_depth = 1)

\method{lsm_c_tca}{stars}(landscape, directions = 8, consider_boundary = FALSE, edge_depth = 1)

\method{lsm_c_tca}{list}(landscape, directions = 8, consider_boundary = FALSE, edge_depth = 1)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}
}
\value{
tibble
}
\description{
Total core area (Core area metric)
}
\details{
\deqn{TCA = \sum_{j = 1}^{n} a_{ij}^{core} * (\frac{1} {10000})}
where here \eqn{a_{ij}^{core}} is the core area in square meters.

TCA is a 'Core area metric' and equals the sum of core areas of all patches belonging
to class i. A cell is defined as core area if the cell has no neighbour with a different
value than itself (rook's case). In other words, the core area of a patch is all area that
is not an edge. It characterises patch areas and shapes of patches belonging to class i
simultaneously (more core area when the patch is large and the shape is rather compact,
i.e. a square). Additionally, TCA is a measure for the configuration of the landscape,
because the sum of edges increase as patches are less aggregated.

\subsection{Units}{Hectares}
\subsection{Range}{TCA >= 0}
\subsection{Behaviour}{Increases, without limit, as patch areas increase
and patch shapes simplify. TCA = 0 when every cell in every patch of class i
is an edge.}
}
\examples{
lsm_c_tca(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_p_core}},
\code{\link{lsm_l_tca}}
}
