% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_cores.R
\name{show_cores}
\alias{show_cores}
\title{Show core area}
\usage{
show_cores(
  landscape,
  directions = 8,
  class = "all",
  labels = FALSE,
  nrow = NULL,
  ncol = NULL,
  consider_boundary = TRUE,
  edge_depth = 1
)
}
\arguments{
\item{landscape}{Raster object}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{class}{How to show the core area: "global" (single map), "all" (every class as facet), or a vector with the specific classes one wants to show (every selected class as facet).}

\item{labels}{Logical flag indicating whether to print or not to print core labels.
boundary should be considered as core}

\item{nrow, ncol}{Number of rows and columns for the facet.}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core.}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}
}
\value{
ggplot
}
\description{
Show core area
}
\details{
The functions plots the core area of patches labeled with the
corresponding patch id. The edges are the grey cells surrounding the patches and are always shown.
}
\examples{
# show "global" core area
show_cores(landscape, class = "global", labels = FALSE)

# show the core area of every class as facet
show_cores(landscape, class = "all", labels = FALSE)

# show only the core area of class 1 and 3
show_cores(landscape, class = c(1, 3), labels = TRUE)

}
