% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_sidi.R
\name{lsm_l_sidi}
\alias{lsm_l_sidi}
\title{SIDI (landscape level)}
\usage{
lsm_l_sidi(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Simpson's diversity index (Diversity metric)
}
\details{
\deqn{SIDI = 1 - \sum \limits_{i = 1}^{m} P_{i}^{2}}
where \eqn{P_{i}} is the proportion of class i and \eqn{m} is the
number of classes.

SIDI is a 'Diversity metric'. It is widely used in biodiversity and ecology. It is
less sensitive to rare class types than \code{\link{lsm_l_shdi}}. It can be interpreted
as the probability that two randomly selected cells belong to the same class.

\subsection{Units}{None}
\subsection{Range}{0 <= SIDI < 1}
\subsection{Behaviour}{Equals SIDI = 0 when only one patch is present and approaches
SIDI < 1 when the number of class types increases while the proportions are equally
distributed}
}
\examples{
lsm_l_sidi(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/

Simpson, E. H. 1949. Measurement of diversity. Nature 163:688
}
\seealso{
\code{\link{lsm_c_pland}},
\code{\link{lsm_l_pr}}
}
