% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_window.R
\name{scale_window}
\alias{scale_window}
\title{scale_window}
\usage{
scale_window(
  landscape,
  percentages_col = NULL,
  percentages_row = NULL,
  what,
  stat,
  verbose = TRUE,
  progress = FALSE,
  ...
)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{percentages_col}{2-column matrix with coordinates or SpatialPoints.}

\item{percentages_row}{String specifying plot shape. Either "circle" or "square"}

\item{what}{Selected level of metrics: either "patch", "class" or "landscape".
It is also possible to specify functions as a vector of strings, e.g. \code{what = c("lsm_l_mutinf", "lsm_l_ta")}.}

\item{stat}{The function to be applied. See Details}

\item{verbose}{If TRUE, warnings are printed.}

\item{progress}{Print progress report.}

\item{...}{Arguments passed on to \code{calculate_lsm()}.}
}
\value{
tibble
}
\description{
Metrics on changing sample scale
}
\details{
This function calculates the selected metrics in moving windows over the provided
landscape.

Please be aware that the output is sligthly different to all other \code{lsm}-function
of \code{landscapemetrics}.

The metrics can be specified by the arguments \code{what}, \code{level}, \code{metric}, \code{name}
and/or \code{type} (combinations of different arguments are possible (e.g.
\verb{level = "class", type = "aggregation metric"}). If an argument is not provided,
automatically all possibilities are selected. Only metrics on landscape level
are supported for this function.
}
\examples{
\dontrun{
percentages_col <- c(2, 4, 8, 16, 32, 64, 100)
percentages_row <- c(2, 4, 8, 16, 32, 64, 100)

what =  c("lsm_l_pr", "lsm_l_joinent")

stat <- "mean"

scale_window(landscape, percentages_col, percentages_row, what, stat)
}

}
\seealso{
\code{\link{list_lsm}} \cr
\code{\link{window_lsm}} \cr
\code{\link{scale_sample}}
}
