% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robyn.R
\name{robyn_performance}
\alias{robyn_performance}
\title{Robyn: Dynamic Performance and Contribution Report}
\usage{
robyn_performance(
  InputCollect,
  OutputCollect,
  start_date = NULL,
  end_date = NULL,
  solID = NULL,
  totals = TRUE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{InputCollect, OutputCollect}{Robyn output objects.}

\item{start_date, end_date}{Date. Start and end date to filter
the data to be reported.}

\item{solID}{Character. Single ID of the model to report. If there's
only one available in OutputCollect, no need to define.}

\item{totals}{Boolean. Add total rows. This includes summary rows
(promotional which is paid and organic channels, baseline, grand total).}

\item{quiet}{Boolean. Keep quiet? If not, message will be shown.}

\item{...}{Additional parameters.}
}
\value{
data.frame with results on ROAS/CPA, spend, response, contribution
per channel, with or without total rows.
}
\description{
Given a date range, calculate specific and total performance and
contribution for each of your marketing and non-marketing channels.
}
\examples{
\dontrun{
# You may load an exported model to recreate Robyn objects
mod <- Robyn::robyn_recreate(json_file = "your_model.json")
robyn_performance(mod$InputCollect, mod$OutputCollect)
}
}
\seealso{
Other Robyn: 
\code{\link{robyn_hypsbuilder}()},
\code{\link{robyn_modelselector}()}
}
\concept{Robyn}
