% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.R
\name{outlier_zscore_plot}
\alias{outlier_zscore_plot}
\title{Outliers: Z-score method plot}
\usage{
outlier_zscore_plot(df, var, group = NULL, thresh = c(2, 3, 5), top = 5)
}
\arguments{
\item{df}{Dataframe.}

\item{var}{Numeric variable.}

\item{group}{Categorical variable. Grouping variable.}

\item{thresh}{Numeric vector. Z-Score threshold for n standard deviations.}

\item{top}{Integer. Show only n most frequent categorical values when
using the \code{group} argument.}
}
\value{
ggplot2 object
}
\description{
Test several Z-score thresholds to visualize outliers. Tidyverse
friendly.
}
\examples{
Sys.unsetenv("LARES_FONT") # Temporal
data(dft) # Titanic dataset
outlier_zscore_plot(dft, Fare)
p <- outlier_zscore_plot(dft, Fare, Pclass, thresh = c(3, 5))
plot(p)
attr(p, "z_values")
head(attr(p, "z_labels"))
}
\seealso{
Other Outliers: 
\code{\link{outlier_tukey}()},
\code{\link{outlier_zscore}()},
\code{\link{winsorize}()}
}
\concept{Outliers}
