% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodLMKM.R
\name{lcMethodLMKM}
\alias{lcMethodLMKM}
\title{Two-step clustering through linear regression modeling and k-means}
\usage{
lcMethodLMKM(
  formula,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  nClusters = 2,
  center = meanNA,
  standardize = scale,
  ...
)
}
\arguments{
\item{formula}{A \code{formula} specifying the linear trajectory model.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identification variable.}

\item{nClusters}{The number of clusters to estimate.}

\item{center}{A  \code{function} that computes the cluster center based on the original trajectories associated with the respective cluster.
By default, the mean is computed.}

\item{standardize}{A \code{function} to standardize the output \code{matrix} of the representation step. By default, the output is shifted and rescaled to ensure zero mean and unit variance.}

\item{...}{Arguments passed to \link[stats:lm]{stats::lm}.
The following external arguments are ignored: x, data, control, centers, trace.}
}
\description{
Two-step clustering through linear regression modeling and k-means
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time", nClusters = 3)
model <- latrend(method, latrendData)
}
\seealso{
Other lcMethod implementations: 
\code{\link{getArgumentDefaults}()},
\code{\link{getArgumentExclusions}()},
\code{\link{lcMethod-class}},
\code{\link{lcMethodAkmedoids}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFeature}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodFunction}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}}
}
\concept{lcMethod implementations}
