% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{PAP.adh}
\alias{PAP.adh}
\title{Weekly Mean PAP Therapy Usage of OSA Patients in the First 3 Months}
\format{
A \code{data.frame} comprising longitudinal data of 500 patients, each having 26 observations
over a period of 1 year.
Each row represents a patient observation interval (two weeks), with columns:
\describe{
\item{Patient}{\code{integer}: The patient identifier, where each level represents a simulated patient.}
\item{Week}{\code{integer}: The week number, starting from 1.}
\item{UsageHours}{\code{numeric}: The mean hours of usage in the respective week.
Greater than or equal to zero, and typically around 4-6 hours.}
\item{Group}{\code{factor}: The reference group (i.e., adherence pattern) from which this patient was generated.}
}

\insertRef{yi2022identifying}{latrend}
}
\usage{
PAP.adh
}
\description{
A simulated longitudinal dataset comprising 301 patients with obstructive sleep apnea (OSA)
during their first 91 days (13 weeks) of PAP therapy.
The longitudinal patterns were inspired by the adherence patterns reported by Yi et al. (2022),
interpolated to weekly hours of usage.
}
\examples{
data(PAP.adh)

if (require("ggplot2")) {
  plotTrajectories(PAP.adh, id = "Patient", time = "Week", response = "UsageHours")

  # plot according to cluster ground truth
  plotTrajectories(
    PAP.adh,
    id = "Patient",
    time = "Week",
    response = "UsageHours",
    cluster = "Group"
  )
}
}
\seealso{
\link{latrend-data} \link{PAP.adh1y}
}
\keyword{datasets}
