% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/trajectories.R, R/model.R
\name{plotClusterTrajectories}
\alias{plotClusterTrajectories}
\alias{plotClusterTrajectories,data.frame-method}
\alias{plotClusterTrajectories,lcModel-method}
\title{Plot cluster trajectories}
\usage{
plotClusterTrajectories(object, ...)

\S4method{plotClusterTrajectories}{data.frame}(
  object,
  response,
  cluster = "Cluster",
  clusterOrder = character(),
  clusterLabeler = make.clusterPropLabels,
  time = getOption("latrend.time"),
  center = meanNA,
  trajectories = c(FALSE, "sd", "se", "80pct", "90pct", "95pct", "range"),
  facet = !isFALSE(as.logical(trajectories[1])),
  id = getOption("latrend.id"),
  ...
)

\S4method{plotClusterTrajectories}{lcModel}(
  object,
  what = "mu",
  at = time(object),
  clusterOrder = character(),
  clusterLabeler = make.clusterPropLabels,
  trajectories = FALSE,
  facet = !isFALSE(as.logical(trajectories[1])),
  ...
)
}
\arguments{
\item{object}{The (cluster) trajectory data.}

\item{...}{Additional arguments passed to \link{clusterTrajectories}.}

\item{response}{The response variable name, see \link{responseVariable}.}

\item{cluster}{The cluster assignment column}

\item{clusterOrder}{Specify which clusters to plot and the order.
Can be the cluster names or index.
By default, all clusters are shown.}

\item{clusterLabeler}{A \verb{function(clusterNames, clusterSizes)} that generates plot labels for the clusters.
By default the cluster name with the proportional size is shown, see \link{make.clusterPropLabels}.}

\item{time}{The time variable name, see \link{timeVariable}.}

\item{center}{A function for aggregating multiple points at the same point in time}

\item{trajectories}{Whether to additionally plot the original trajectories (\code{TRUE}),
or to show the expected interval (standard deviation, standard error, range, or percentile range)
of the observations at the respective moment in time.

Note that visualizing the expected intervals is currently only supported for time-aligned trajectories,
as the interval is computed at each unique moment in time.
By default (\code{FALSE}), no information on the underlying trajectories is shown.}

\item{facet}{Whether to facet by cluster. This is done by default when \code{trajectories} is enabled.}

\item{id}{Id column. Only needed when \code{trajectories = TRUE}.}

\item{what}{The distributional parameter to predict. By default, the mean response 'mu' is predicted. The cluster membership predictions can be obtained by specifying \code{what = 'mb'}.}

\item{at}{A \verb{numeric vector} of the times at which to compute the cluster trajectories.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the cluster trajectories associated with the given model.
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData, nClusters = 3)

if (require("ggplot2")) {
  plotClusterTrajectories(model)

  # show cluster sizes in labels
  plotClusterTrajectories(model, clusterLabeler = make.clusterSizeLabels)

  # change cluster order
  plotClusterTrajectories(model, clusterOrder = c('B', 'C', 'A'))

  # sort clusters by decreasing size
  plotClusterTrajectories(model, clusterOrder = order(-clusterSizes(model)))

  # show only specific clusters
  plotClusterTrajectories(model, clusterOrder = c('B', 'C'))

  # show assigned trajectories
  plotClusterTrajectories(model, trajectories = TRUE)

  # show 95th percentile observation interval
  plotClusterTrajectories(model, trajectories = "95pct")

  # show observation standard deviation
  plotClusterTrajectories(model, trajectories = "sd")

  # show observation standard error
  plotClusterTrajectories(model, trajectories = "se")

  # show observation range
  plotClusterTrajectories(model, trajectories = "range")
}
}
\seealso{
\link{clusterTrajectories}

\link{plotTrajectories} \link{plot}

Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
