% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/estimate.default.R
\name{estimate.default}
\alias{estimate.default}
\alias{estimate.estimate}
\alias{merge.estimate}
\title{Estimation of functional of parameters}
\usage{
\method{estimate}{default}(x = NULL, f = NULL, ..., data, id, iddata,
  stack = TRUE, average = FALSE, subset, score.deriv, level = 0.95,
  iid = TRUE, type = c("robust", "df", "mbn"), keep, contrast, null, vcov,
  coef, robust = TRUE, df = NULL, print = NULL, labels, label.width,
  only.coef = FALSE, transform, folds = 0)
}
\arguments{
\item{x}{model object (\code{glm}, \code{lvmfit}, ...)}

\item{f}{transformation of model parameters and (optionally) data, or contrast matrix (or vector)}

\item{...}{additional arguments to lower level functions}

\item{data}{\code{data.frame}}

\item{id}{(optional) id-variable corresponding to iid decomposition of model parameters.}

\item{iddata}{(optional) id-variable for 'data'}

\item{stack}{If TRUE (default)  the i.i.d. decomposition is automatically stacked according to 'id'}

\item{average}{If TRUE averages are calculated}

\item{subset}{(optional) subset of data.frame on which to condition (logical expression or variable name)}

\item{score.deriv}{(optional) derivative of mean score function}

\item{level}{Level of confidence limits}

\item{iid}{If TRUE (default) the iid decompositions are also returned (extract with \code{iid} method)}

\item{type}{Type of small-sample correction}

\item{keep}{(optional) Index of parameters to keep}

\item{contrast}{(optional) Contrast matrix for final Wald test}

\item{null}{(optional) Null hypothesis to test}

\item{vcov}{(optional) covariance matrix of parameter estimates (e.g. Wald-test)}

\item{coef}{(optional) parameter coefficient}

\item{robust}{If TRUE robust standard errors are calculated. If
FALSE p-values for linear models are calculated from t-distribution}

\item{df}{Degrees of freedom (default obtained from 'df.residual')}

\item{print}{(optional) print function}

\item{labels}{(optional) names of coefficients}

\item{label.width}{(optional) max width of labels}

\item{only.coef}{if TRUE only the coefficient matrix is return}

\item{transform}{(optional) transform of parameters and confidence intervals}

\item{folds}{(optional) Aggregate influence functions (divide and conquer)}
}
\description{
Estimation of functional of parameters.
Wald tests, robust standard errors, cluster robust standard errors,
LRT (when \code{f} is not a function)...
}
\examples{
## Simulation from logistic regression model
m <- lvm(y~x+z);
distribution(m,y~x) <- binomial.lvm("logit")
d <- sim(m,1000)
g <- glm(y~z+x,data=d,family=binomial())
g0 <- glm(y~1,data=d,family=binomial())

## LRT
estimate(g,g0)

## Plain estimates (robust standard errors)
estimate(g)

## Testing contrasts
estimate(g,null=0)
estimate(g,rbind(c(1,1,0),c(1,0,2)))
estimate(g,rbind(c(1,1,0),c(1,0,2)),null=c(1,2))
estimate(g,2:3) ## same as rbind(c(0,1,0),c(0,0,1))
## Alternative syntax
estimate(g,"z","z"-"x",2*"z"-3*"x")
estimate(g,"1","2"-"3",null=c(0,1))
## Usual (non-robust) confidence intervals
estimate(g,robust=FALSE)

## Transformations
estimate(g,function(p) p[1]+p[2])

## Multiple parameters
e <- estimate(g,function(p) c(p[1]+p[2],p[1]*p[2]))
e
vcov(e)

## Label new parameters
estimate(g,function(p) list("a1"=p[1]+p[2],"b1"=p[1]*p[2]))
##'
## Multiple group
m <- lvm(y~x)
m <- baptize(m)
d2 <- d1 <- sim(m,50)
e <- estimate(list(m,m),list(d1,d2))
estimate(e) ## Wrong
estimate(e,id=rep(seq(nrow(d1)),2))
estimate(lm(y~x,d1))

## Marginalize
f <- function(p,data)
  list(p0=lava:::expit(p[1] + p[3]*data[,"z"]),
       p1=lava:::expit(p[1] + p[2] + p[3]*data[,"z"]))
e <- estimate(g, f, average=TRUE)
e
estimate(e,diff)
estimate(e,cbind(1,1))

## Clusters and subset (conditional marginal effects)
d$id <- rep(seq(nrow(d)/4),each=4)
estimate(g,function(p,data)
         list(p0=lava:::expit(p[1] + p["z"]*data[,"z"])),
         subset=d$z>0, id=d$id, average=TRUE)

## More examples with clusters:
m <- lvm(c(y1,y2,y3)~u+x)
d <- sim(m,10)
l1 <- glm(y1~x,data=d)
l2 <- glm(y2~x,data=d)
l3 <- glm(y3~x,data=d)

## Some random id-numbers
id1 <- c(1,1,4,1,3,1,2,3,4,5)
id2 <- c(1,2,3,4,5,6,7,8,1,1)
id3 <- seq(10)

## Un-stacked and stacked i.i.d. decomposition
iid(estimate(l1,id=id1,stack=FALSE))
iid(estimate(l1,id=id1))

## Combined i.i.d. decomposition
e1 <- estimate(l1,id=id1)
e2 <- estimate(l2,id=id2)
e3 <- estimate(l3,id=id3)
(a2 <- merge(e1,e2,e3))

## Same:
iid(a1 <- merge(l1,l2,l3,id=list(id1,id2,id3)))

iid(merge(l1,l2,l3,id=TRUE)) # one-to-one (same clusters)
iid(merge(l1,l2,l3,id=FALSE)) # independence
}

