\name{lavMatrixRepresentation}
\alias{lavMatrixRepresentation}
\title{lavaan matrix representation}
\description{
Extend the parameter table with a matrix representation.
}
\usage{
lavMatrixRepresentation(partable, representation = "LISREL", 
                        as.data.frame. = TRUE)
}
\arguments{
\item{partable}{A lavaan parameter table (as extracted by the 
\code{\link{parTable}} function, or generated by the 
\code{\link{lavPartable}} function).}
\item{representation}{The matrix representation style.
Currently, only the all-y version of the LISREL representation 
is supported.}
\item{as.data.frame.}{If \code{TRUE}, the extended parameter table is
returned as a data.frame.}
}
\value{
A list or a data.frame containing the original parameter table, plus
three columns: a \code{"mat"} column containing matrix names, and
a \code{"row"} and \code{"col"} column for the row and column indices
of the model parameters in the model matrices.
}
\seealso{\code{\link{lavParTable}}, \code{\link{parTable}}}
\examples{
HS.model <- ' visual  =~ x1 + x2 + x3
              textual =~ x4 + x5 + x6
              speed   =~ x7 + x8 + x9 '

fit <- cfa(HS.model, data=HolzingerSwineford1939)

# extract partable
partable <- parTable(fit)

# add matrix representation (and show only a few columns)
lavMatrixRepresentation(partable)[,c("lhs","op","rhs","mat","row","col")]
}
