% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipolygon.R
\name{lawn_multipolygon}
\alias{lawn_multipolygon}
\title{Create a multipolygon}
\usage{
lawn_multipolygon(coordinates, properties = NULL)
}
\arguments{
\item{coordinates}{A list of LinearRings, or in json.}

\item{properties}{A list of properties.}
}
\value{
A \link{data-Feature}<(\link{data-MultiPolygon})>
}
\description{
Create a multipolygon
}
\examples{
rings <- list(
  list(list(
   c(-2.27, 53.46),
   c(-2.27, 53.48),
   c(-2.21, 53.48),
   c(-2.21, 53.46),
   c(-2.27, 53.46)
  )),
  list(list(
   c(-4.27, 55.46),
   c(-4.27, 55.48),
   c(-4.21, 55.48),
   c(-4.21, 55.46),
   c(-4.27, 55.46)
  ))
)
lawn_multipolygon(rings)
lawn_multipolygon(rings, properties = list(name = 'poly1', population = 400))

x <- '[
  [[[102.0, 2.0], [103.0, 2.0], [103.0, 3.0], [102.0, 3.0], [102.0, 2.0]]],
  [[[100.0, 0.0], [101.0, 0.0], [101.0, 1.0], [100.0, 1.0], [100.0, 0.0]],
  [[100.2, 0.2], [100.8, 0.2], [100.8, 0.8], [100.2, 0.8], [100.2, 0.2]]]
]'
lawn_multipolygon(x)

lawn_multipolygon("[[[[0,0],[0,10],[10,10],[10,0],[0,0]]]]")

# Make a FeatureCollection
lawn_featurecollection(lawn_multipolygon(rings))

\dontrun{
lawn_featurecollection(lawn_multipolygon(rings)) \%>\% view
}
}
\seealso{
Other data functions: \code{\link{lawn_featurecollection}},
  \code{\link{lawn_feature}}, \code{\link{lawn_filter}},
  \code{\link{lawn_geometrycollection}},
  \code{\link{lawn_linestring}},
  \code{\link{lawn_multilinestring}},
  \code{\link{lawn_multipoint}}, \code{\link{lawn_point}},
  \code{\link{lawn_polygon}}, \code{\link{lawn_random}},
  \code{\link{lawn_remove}}, \code{\link{lawn_sample}}
}
\concept{data functions}
