% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazyNumbers.R
\name{isNaN_or_Inf}
\alias{isNaN_or_Inf}
\title{Lazy infinite or NaN numbers}
\usage{
isNaN_or_Inf(x)
}
\arguments{
\item{x}{a lazy vector or a lazy matrix}
}
\value{
A logical vector or a logical matrix.
}
\description{
Check whether values are infinite or NaN in lazy vectors and 
  lazy matrices.
}
\note{
If you want to check whether a lazy number is infinite or whether 
  a lazy number is NaN, you have to call `as.double`. There is no way to 
  distinguish an infinite lazy number from a NaN lazy number without 
  resorting to its double approximation.
}
\examples{
isNaN_or_Inf(lazyvec(c(1, NaN, NA, Inf)))
}
