% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/interp.R
\name{interp}
\alias{interp}
\title{Interpolate values into an expression.}
\usage{
interp(`_obj`, ..., .values)
}
\arguments{
\item{_obj}{An object to modify: can be a call, name, formula,
\code{\link{lazy}}, or a string.}

\item{...,.values}{Either individual name-value pairs, or a list
(or environment) of values.}
}
\description{
This is useful if you want to build an expression up from a mixture of
constants and variables.
}
\examples{
# Interp works with formulas, lazy objects, quoted calls and strings
interp(~ x + y, x = 10)
interp(lazy(x + y), x = 10)
interp(quote(x + y), x = 10)
interp("x + y", x = 10)

# Use as.name if you have a character string that gives a
# variable name
interp(~ mean(var), var = as.name("mpg"))
# or supply the quoted name directly
interp(~ mean(var), var = quote(mpg))

# Or a function!
interp(~ f(a, b), f = as.name("+"))
# Remember every action in R is a function call:
# http://adv-r.had.co.nz/Functions.html#all-calls

# If you've built up a list of values through some other
# mechanism, use .values
interp(~ x + y, .values = list(x = 10))

# You can also interpolate variables defined in the current
# environment, but this is a little risky.
y <- 10
interp(~ x + y, .values = environment())
}

