% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldhmm-mle.R
\name{ldhmm.mle}
\alias{ldhmm.mle}
\title{Computing the MLEs}
\usage{
ldhmm.mle(object, x, print.level = 0, iterlim = 1000, ...)
}
\arguments{
\item{object}{an ldhmm object that can supply m, param.nbr and stationary.}

\item{x}{numeric, the observations.}

\item{print.level}{numeric, this argument determines the level of printing 
which is done during the minimization process. 
The default value of 0 means that no printing occurs, 
a value of 1 means that initial and final details are printed 
and a value of 2 means that full tracing information is printed.}

\item{iterlim}{numeric, a positive integer specifying the maximum number of iterations 
to be performed before the program is terminated.}

\item{...}{additional parameters passed to the MLE optimizer}
}
\value{
an ldhmm object containg results of MLE optimization
}
\description{
Computing the MLEs using \code{nlm} package
}
\examples{
\dontrun{
    param0 <- matrix(c(0.003, 0.02, 1, -0.006, 0.03, 1.3), 2, 3, byrow=TRUE)
    gamma0 <- matrix(c(0.9, 0.1, 0.1, 0.9), 2, 2, byrow=TRUE)
    h <- ldhmm(m=2, param=param0, gamma=gamma0)
    spx <- ldhmm.ts_log_rtn()
    ldhmm.mle(h, spx$x)
}
}
\author{
Stephen H. Lihn
}
\keyword{mle}

