% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.R
\name{mapSymbols}
\alias{mapSymbols}
\alias{makeSymbol}
\alias{makeSymbolIcons}
\alias{addSymbols}
\alias{addSymbolsSize}
\alias{sizeNumeric}
\alias{sizeBreaks}
\alias{makeSymbolsSize}
\title{Create Map Symbols for 'leaflet' maps}
\usage{
makeSymbol(
  shape,
  width,
  height = width,
  color,
  fillColor = color,
  opacity = 1,
  fillOpacity = opacity,
  ...
)

makeSymbolIcons(
  shape = c("rect", "circle", "triangle", "plus", "cross", "diamond", "star",
    "stadium", "line", "polygon"),
  color,
  fillColor = color,
  opacity,
  fillOpacity = opacity,
  strokeWidth = 1,
  width,
  height = width,
  ...
)

addSymbols(
  map,
  lng,
  lat,
  values,
  shape = c("rect", "circle", "triangle", "plus", "cross", "diamond", "star"),
  color,
  fillColor = color,
  opacity = 1,
  fillOpacity = opacity,
  strokeWidth = 1,
  width = 20,
  height = width,
  data = leaflet::getMapData(map),
  ...
)

addSymbolsSize(
  map,
  lng,
  lat,
  values,
  shape = c("rect", "circle", "triangle", "plus", "cross", "diamond", "star"),
  color,
  fillColor = color,
  opacity = 1,
  fillOpacity = opacity,
  strokeWidth = 1,
  baseSize = 20,
  data = leaflet::getMapData(map),
  ...
)

sizeNumeric(values, baseSize)

sizeBreaks(values, breaks, baseSize, ...)

makeSymbolsSize(
  values,
  shape = c("rect", "circle", "triangle", "plus", "cross", "diamond", "star",
    "stadium", "polygon"),
  color,
  fillColor,
  opacity = 1,
  fillOpacity = opacity,
  strokeWidth = 1,
  baseSize,
  ...
)
}
\arguments{
\item{shape}{the desired shape of the symbol}

\item{width}{in pixels}

\item{height}{in pixels}

\item{color}{stroke color}

\item{fillColor}{fill color}

\item{opacity}{stroke opacity}

\item{fillOpacity}{fill opacity}

\item{...}{arguments to pass to \code{pretty}}

\item{strokeWidth}{stroke width in pixels}

\item{map}{a map widget object created from 'leaflet'}

\item{lng}{a numeric vector of longitudes, or a one-sided formula of the form \code{~x}
where \code{x} is a variable in \code{data}; by default
(if not explicitly provided), it will be automatically inferred from data
by looking for a column named \code{lng}, \code{long}, or \code{longitude}
(case-insensitively)}

\item{lat}{a vector of latitudes or a formula (similar to the \code{lng} argument; the
names \code{lat} and \code{latitude} are used when guessing the latitude
column from \code{data})}

\item{values}{the values used to generate shapes; can be omitted for a single type of
shape}

\item{data}{the data object from which the argument values are derived; by default, it
is the \code{data} object provided to \code{leaflet()} initially, but can be
overridden}

\item{baseSize}{re-scaling size in pixels of the mean of the values, the average value will
be this exact size}

\item{breaks}{an integer specifying the number of breaks or a numeric vector of the breaks}
}
\value{
HTML svg element
}
\description{
Create Map Symbols for 'leaflet' maps
}
