% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumulative_avg_models.R
\name{ca_unit}
\alias{ca_unit}
\title{Wright's Cumulative Average Unit Learning Curve Function}
\usage{
ca_unit(t, n, r, m = 1, na.rm = FALSE)
}
\arguments{
\item{t}{time (or cost) required for the mth unit of production}

\item{n}{nth unit you wish to predict the time (or cost) for}

\item{r}{learning curve rate}

\item{m}{mth unit for which you have time (or cost) information (default is m = 1)}

\item{na.rm}{Should \code{NA} values be removed?}
}
\description{
Computes the time (or cost) required for a specific unit using Wright's cumulative average model.
}
\examples{
# An estimator want to know the unit hours for unit 2,200 using
# when the hours for unit 1 were 110 and the learning rate was
# 88.5\%.

ca_unit(t = 110, m = 1, n = 2200, r = .885)
## [1] 23.34001
}

