% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_leri.R
\name{get_leri}
\alias{get_leri}
\title{Get LERI data}
\usage{
get_leri(date, product, dir = tempdir(), overwrite = FALSE)
}
\arguments{
\item{date}{An object of class Date or a character string formatted as
%Y-%m-%d (e.g., "2016-04-01") which specifies the date(s) for which data
are to be acquired. To specify a time interval or date range, date can be
a vector of class Date such as produced by \code{seq.Date}.}

\item{product}{A string that specifies which LERI product to get, e.g.,
"1 month", "3 month", "7 month", or "12 month" for their monthly data, or
"8 day ac", or "8 day nac" for accumulated and non-accumulated
(respectively) 8-day LERI products. Fractional timescales
are not supported, and will be rounded to the nearest integer (e.g., "1.1
month" will be converted to "1 month").}

\item{dir}{Directory to for downloaded LERI data. By default this will be
a temporary directory. This should be a file path specified as a string.}

\item{overwrite}{Boolean to indicate whether to overwrite LERI data that
already exist locally in \code{dir}. Defaults to FALSE.}
}
\value{
A Raster* object containing LERI data. Each layer in this object
corresponds to a unique LERI data file. In cases where one LERI file covers
multiple dates that were provided in the \code{date} argument, the number
of layers in the returned Raster* object may be less than the number of
dates queried. For example, if a user requests the 8 day LERI product for
two consecutive dates, both of those dates might be contained in the same
8 day LERI data product. The time intervals covered by each layer in the
Raster* object returned by \code{get_leri} are available as layer names.
}
\description{
This function searches for LERI data by date, returning a
\code{Raster*} object.
}
\details{
The Landscape Evaporative Response Index (LERI) is available from 2000 to
present, with a ~5 day lag to the current date. Products are available at
multiple timescales. Monthly LERI data are available at the 1, 3, 7, and 12
month timescale for each month of the year. During the growing season (April
through the end of October), there are two additional LERI products:

\itemize{
  \item "Non-accumulated" 8-day data, which represent deviations in LERI
    within an eight day time frame (for example, the time period from
    May 01 to May 08).
  \item "Accumulated" 8-day data, which represent deviations in LERI for
    the period from April 1 to the end of the eight day time frame (for
    example, the time period from April 01 to May 08).
}

The values in LERI rasters are percentiles for estimates of actual
evapotranspiration computed by the operational Simplified Surface Energy
Balance (SEEBop) model, which uses remotely sensed MODIS thermal imagery
with climatological reference evapotranspiration as descriped in Senay et
al., 2013.

More information about how the monthly, non-accumulated 8-day, and
accumulated 8-day data differ can be found at
\url{https://www.esrl.noaa.gov/psd/leri/}.
}
\examples{
\donttest{
# this may take a while, as it downloads ~72 MB
get_leri(date = "2018-01-01", product = "1 month")

# multi-day example that returns a two-layer raster
r <- get_leri(date = c("2018-08-12", "2018-08-13"), product = "8 day nac")
names(r) # has two elements (Aug05-Aug12, and Aug13-Aug20)
}

}
\references{
Senay, Gabriel B., Stefanie Bohms, Ramesh K. Singh, Prasanna H. Gowda,
Naga M. Velpuri, Henok Alemu, James P. Verdin, 2013b. Operational
Evapotranspiration Mapping Using Remote Sensing and Weather Datasets: A New
Parameterization for the SSEB Approach. Journal of the American Water
Resources Association (JAWRA). 49(3):577-591.
\url{http://onlinelibrary.wiley.com/doi/10.1111/jawr.12057/full}
}
