## ---------------------------------------------------------------------------------------------------------------------
library("lessR")

## ----read-------------------------------------------------------------------------------------------------------------
d <- Read("Employee")

## ---------------------------------------------------------------------------------------------------------------------
ttest(Salary)

## ---- fig.height=3.75, fig.width=5------------------------------------------------------------------------------------
ttest(Salary, mu=52000)

## ---------------------------------------------------------------------------------------------------------------------
ttest(n=37, m=73795.557, s=21799.533, Ynm="Salary", mu=52000)

## ---- fig.height=4.25, fig.width=5------------------------------------------------------------------------------------
ttest(Salary ~ Gender)

## ---- fig.height=4.25, fig.width=5------------------------------------------------------------------------------------
tt_brief(Salary ~ Gender)

## ---- fig.height=4.25, fig.width=5------------------------------------------------------------------------------------
tt_brief(Pre, Post)

## ---------------------------------------------------------------------------------------------------------------------
ANOVA(breaks ~ tension, data=warpbreaks)

## ---------------------------------------------------------------------------------------------------------------------
av_brief(breaks ~ tension, data=warpbreaks)

## ---------------------------------------------------------------------------------------------------------------------
ANOVA(breaks ~ tension * wool, data=warpbreaks)


## ---------------------------------------------------------------------------------------------------------------------
d <- read.csv(header=TRUE, text="
Person,sup1,sup2,sup3,sup4
p1,2,4,4,3
p2,2,5,4,6
p3,8,6,7,9
p4,4,3,5,7
p5,2,1,2,3
p6,5,5,6,8
p7,2,3,2,4")

## ---------------------------------------------------------------------------------------------------------------------
d <- reshape(d, direction="long",
        idvar="Person", v.names="Reps",
        varying=list(2:5), timevar="Supplement", times=names(d)[2:5])
row.names(d) <- NULL

## ---------------------------------------------------------------------------------------------------------------------
d[1:10,]

## ---------------------------------------------------------------------------------------------------------------------
ANOVA(Reps ~ Supplement + Person)

