% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lgcpMethods.R
\name{expectation.lgcpPredict}
\alias{expectation.lgcpPredict}
\title{expectation.lgcpPredict function}
\usage{
\method{expectation}{lgcpPredict}(obj, fun, maxit = NULL, ...)
}
\arguments{
\item{obj}{an object of class lgcpPredict}

\item{fun}{a function accepting a single argument that returns a numeric vector, matrix or array object}

\item{maxit}{Not used in ordinary circumstances. Defines subset of samples over which to compute expectation. Expectation is computed using information from iterations 1:maxit, where 1 is the first non-burn in iteration dumped to disk.}

\item{...}{additional arguments}
}
\value{
the expectated value of that function
}
\description{
\bold{This function requires data to have been dumped to disk}: see \code{?dump2dir} and \code{?setoutput}. This function computes the
Monte Carlo Average of a function where data from a run of \code{lgcpPredict} has been dumped to disk.
}
\details{
A Monte Carlo Average is computed as:
\deqn{E_{\pi(Y_{t_1:t_2}|X_{t_1:t_2})}[g(Y_{t_1:t_2})] \approx \frac1n\sum_{i=1}^n g(Y_{t_1:t_2}^{(i)})}{E_{\pi(Y_{t_1:t_2}|X_{t_1:t_2})}[g(Y_{t_1:t_2})] \approx \frac1n\sum_{i=1}^n g(Y_{t_1:t_2}^{(i)})}
where \eqn{g}{g} is a function of interest, \eqn{Y_{t_1:t_2}^{(i)}}{Y_{t_1:t_2}^{(i)}} is the \eqn{i}{i}th retained sample from the target
and \eqn{n}{n} is the total number of retained iterations. For example, to compute the mean of \eqn{Y_{t_1:t_2}}{Y_{t_1:t_2}} set,
\deqn{g(Y_{t_1:t_2}) = Y_{t_1:t_2},}{g(Y_{t_1:t_2}) = Y_{t_1:t_2},}
the output from such a Monte Carlo average would be a set of \eqn{t_2-t_1}{t_2-t_1} grids, each cell of which
being equal to the mean over all retained iterations of the algorithm (NOTE: this is just an example computation, in
practice, there is no need to compute the mean on line explicitly, as this is already done by default in \code{lgcpPredict}).
}
\seealso{
\link{lgcpPredict}, \link{dump2dir}, \link{setoutput}
}

