% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-simulate.R
\name{sim.kernels}
\alias{sim.kernels}
\title{Compute all kernel matrices when simulating data}
\usage{
sim.kernels(
  X,
  types,
  lengthscales,
  X_affected,
  bin_kernel,
  useMaskedVarianceKernel,
  steepness,
  vm_params
)
}
\arguments{
\item{X}{covariates}

\item{types}{vector of covariate types, so that
\itemize{
  \item 1 = ID
  \item 2 = age
  \item 3 = diseaseAge
  \item 4 = other continuous covariate
  \item 5 = a categorical covariate that interacts with age
  \item 6 = a categorical covariate that acts as an offset
}}

\item{lengthscales}{vector of lengthscales}

\item{X_affected}{which individuals are affected by the disease}

\item{bin_kernel}{whether or not binary (mask) kernel should be used for
categorical covariates (if not, the zerosum kernel is used)}

\item{useMaskedVarianceKernel}{should the masked variance kernel be used
for drawing the disease component}

\item{steepness}{steepness of the input warping function}

\item{vm_params}{parameters of the variance mask function}
}
\value{
a 3D array
}
\description{
Compute all kernel matrices when simulating data
}
