% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Appender.R
\name{AppenderMemory}
\alias{AppenderMemory}
\title{Abstract class for logging to memory buffers}
\description{
\strong{NOTE}: This is an \emph{abstract class}. Abstract classes cannot be instantiated
directly, but are exported for package developers that want to extend lgr -
for example by creating their own \link[=Appender]{Appenders} or \link[=Layout]{Layouts}.
Please refer to the \emph{see also} section for actual implementations of this
class.

AppenderMemory is extended by Appenders that retain an in-memory event
buffer, such as \link{AppenderBuffer} and \code{AppenderPushbullet} from the
\href{https://github.com/s-fleck/lgrExtra}{lgrExtra} package.
}
\seealso{
\link{LayoutFormat}

Other abstract classes: 
\code{\link{AppenderTable}},
\code{\link{Appender}},
\code{\link{Filterable}}
}
\concept{abstract classes}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Appender]{lgr::Appender}} -> \code{AppenderMemory}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{flush_on_exit}}{A \code{logical} scalar. Should the buffer be flushed if
the Appender is destroyed (e.g. because the \R session is terminated)?}

\item{\code{flush_on_rotate}}{A \code{logical} scalar. Should the buffer be flushed when it is
rotated because \verb{$buffer_size} is exceeded?}

\item{\code{should_flush}}{A \code{function} with exactly one arguments: \code{event}.
\verb{$append()} calls this function internally on the current \link{LogEvent}
and flushes the buffer if it evaluates to \code{TRUE}.}

\item{\code{buffer_size}}{\code{integer} scalar \verb{>= 0}. Maximum number of \link{LogEvents}
to buffer.}

\item{\code{flush_threshold}}{A \code{numeric} or \code{character} threshold. \link{LogEvents}
with a \link{log_level} equal to or lower than this threshold trigger
flushing the buffer.}

\item{\code{buffer_events}}{A \code{list} of \link{LogEvents}. Contents of the buffer.}

\item{\code{buffer_events}}{A \code{data.frame}. Contents of the buffer converted
to a \code{data.frame}.}

\item{\code{buffer_events}}{A \code{data.frame}. Contents of the buffer converted
to a \code{data.table}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AppenderMemory-new}{\code{AppenderMemory$new()}}
\item \href{#method-AppenderMemory-append}{\code{AppenderMemory$append()}}
\item \href{#method-AppenderMemory-flush}{\code{AppenderMemory$flush()}}
\item \href{#method-AppenderMemory-clear}{\code{AppenderMemory$clear()}}
\item \href{#method-AppenderMemory-set_buffer_size}{\code{AppenderMemory$set_buffer_size()}}
\item \href{#method-AppenderMemory-set_should_flush}{\code{AppenderMemory$set_should_flush()}}
\item \href{#method-AppenderMemory-set_flush_on_exit}{\code{AppenderMemory$set_flush_on_exit()}}
\item \href{#method-AppenderMemory-set_flush_on_rotate}{\code{AppenderMemory$set_flush_on_rotate()}}
\item \href{#method-AppenderMemory-set_flush_threshold}{\code{AppenderMemory$set_flush_threshold()}}
\item \href{#method-AppenderMemory-show}{\code{AppenderMemory$show()}}
\item \href{#method-AppenderMemory-format}{\code{AppenderMemory$format()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-add_filter'><code>lgr::Filterable$add_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter"><a href='../../lgr/html/Filterable.html#method-Filterable-filter'><code>lgr::Filterable$filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-remove_filter'><code>lgr::Filterable$remove_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters"><a href='../../lgr/html/Filterable.html#method-Filterable-set_filters'><code>lgr::Filterable$set_filters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_layout"><a href='../../lgr/html/Appender.html#method-Appender-set_layout'><code>lgr::Appender$set_layout()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_threshold"><a href='../../lgr/html/Appender.html#method-Appender-set_threshold'><code>lgr::Appender$set_threshold()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderMemory-new"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderMemory-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMemory$new(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderMemory-append"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderMemory-append}{}}}
\subsection{Method \code{append()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMemory$append(event)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderMemory-flush"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderMemory-flush}{}}}
\subsection{Method \code{flush()}}{
Sends the buffer's contents to all attached Appenders and
then clears the Buffer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMemory$flush()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderMemory-clear"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderMemory-clear}{}}}
\subsection{Method \code{clear()}}{
Clears the buffer, discarding all buffered Events
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMemory$clear()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderMemory-set_buffer_size"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderMemory-set_buffer_size}{}}}
\subsection{Method \code{set_buffer_size()}}{
Set the maximum size of the buffer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMemory$set_buffer_size(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{an \code{integer} scalar \verb{>= 0}. Number of \link{LogEvents} to buffer.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderMemory-set_should_flush"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderMemory-set_should_flush}{}}}
\subsection{Method \code{set_should_flush()}}{
Set function that can trigger flushing the buffer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMemory$set_should_flush(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A \code{function} with the single argument \code{event}. Setting \code{x} to
\code{NULL} is a shortcut for \code{function(event) FALSE}. See active bindings.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderMemory-set_flush_on_exit"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderMemory-set_flush_on_exit}{}}}
\subsection{Method \code{set_flush_on_exit()}}{
Should the buffer be flushed when the Appender is destroyed?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMemory$set_flush_on_exit(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A \code{logical} scalar. See active bindings.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderMemory-set_flush_on_rotate"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderMemory-set_flush_on_rotate}{}}}
\subsection{Method \code{set_flush_on_rotate()}}{
Should the buffer be flushed if \code{buffer_size} is exceeded?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMemory$set_flush_on_rotate(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A \code{logical} scalar. See active bindings.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderMemory-set_flush_threshold"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderMemory-set_flush_threshold}{}}}
\subsection{Method \code{set_flush_threshold()}}{
Set threshold that triggers flushing
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMemory$set_flush_threshold(level)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{A \code{numeric} or \code{character} \link[=log_level]{threshold}. See
active bindings.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderMemory-show"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderMemory-show}{}}}
\subsection{Method \code{show()}}{
Display the contents of the log table. Relies on the
\verb{$format_event} method of the \link{Layout} attached to this Appender.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMemory$show(threshold = NA_integer_, n = 20L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{threshold}}{\code{character} or \code{integer} scalar. The minimum log level
that should be displayed.}

\item{\code{n}}{\code{integer} scalar. Show only the last \code{n} log entries that match
\code{threshold}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderMemory-format"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderMemory-format}{}}}
\subsection{Method \code{format()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderMemory$format(color = FALSE, ...)}\if{html}{\out{</div>}}
}

}
}
