% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AppenderDigest.R
\name{AppenderSendmail}
\alias{AppenderSendmail}
\title{Send emails via sendmailR}
\value{
The \verb{$new()} method returns an \link[R6:R6Class]{R6::R6} that inherits from
\link[lgr:Appender]{lgr::Appender} and can be uses as an appender by a \link[lgr:Logger]{lgr::Logger}.
}
\description{
Send mails via \code{\link[sendmailR:sendmail]{sendmailR::sendmail()}}, which requires that you have access
to an SMTP server that does not require authentication. This
Appender keeps an in-memory buffer like \link{AppenderBuffer}. If the buffer is
flushed, usually because an event of specified magnitude is encountered, all
buffered events are concatenated to a single message. The default behavior
is to push the last 30 log events in case a \code{fatal} event is encountered.
}
\note{
The default Layout's \code{fmt} indents each log entry with 3 blanks. This
is a workaround so that Microsoft Outlook does not mess up the line breaks.
}
\examples{
\dontrun{
lgr::AppenderSendmail$new(
  to = "user@ecorp.com",
  control = list(smtpServer = "mail.ecorp.com"),
  from = "lgr_user@yourmail.com"
)
}

if (requireNamespace("sendmailR")){
# requires that you have access to an SMTP server

  lg <- lgr::get_logger("lgrExtra/test/mail")$
    set_propagate(FALSE)$
    add_appender(AppenderSendmail$new(
      from = "ceo@ecorp.com",
      to = "some.guy@ecorp.com",
    control = list(smtpServer = "mail.somesmptserver.com")
  ))
  # cleanup
  invisible(lg$config(NULL))
}
}
\seealso{
\link{LayoutFormat}, \link{LayoutGlue}

Other Appenders: 
\code{\link{AppenderDbi}},
\code{\link{AppenderDt}},
\code{\link{AppenderElasticSearch}},
\code{\link{AppenderGmail}},
\code{\link{AppenderPushbullet}},
\code{\link{AppenderSyslog}}

Other Digest Appenders: 
\code{\link{AppenderDigest}},
\code{\link{AppenderMail}},
\code{\link{AppenderPushbullet}}
}
\concept{Appenders}
\concept{Digest Appenders}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Appender]{lgr::Appender}} -> \code{\link[lgr:AppenderMemory]{lgr::AppenderMemory}} -> \code{\link[lgrExtra:AppenderDigest]{lgrExtra::AppenderDigest}} -> \code{\link[lgrExtra:AppenderMail]{lgrExtra::AppenderMail}} -> \code{AppenderSendmail}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{control}}{see \code{\link[sendmailR:sendmail]{sendmailR::sendmail()}}}

\item{\code{headers}}{see \code{\link[sendmailR:sendmail]{sendmailR::sendmail()}}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AppenderSendmail$new()}}
\item \href{#method-flush}{\code{AppenderSendmail$flush()}}
\item \href{#method-set_control}{\code{AppenderSendmail$set_control()}}
\item \href{#method-set_headers}{\code{AppenderSendmail$set_headers()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter">}\href{../../lgr/html/Filterable.html#method-add_filter}{\code{lgr::Filterable$add_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter">}\href{../../lgr/html/Filterable.html#method-filter}{\code{lgr::Filterable$filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter">}\href{../../lgr/html/Filterable.html#method-remove_filter}{\code{lgr::Filterable$remove_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters">}\href{../../lgr/html/Filterable.html#method-set_filters}{\code{lgr::Filterable$set_filters()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_layout">}\href{../../lgr/html/Appender.html#method-set_layout}{\code{lgr::Appender$set_layout()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_threshold">}\href{../../lgr/html/Appender.html#method-set_threshold}{\code{lgr::Appender$set_threshold()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="append">}\href{../../lgr/html/AppenderMemory.html#method-append}{\code{lgr::AppenderMemory$append()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="clear">}\href{../../lgr/html/AppenderMemory.html#method-clear}{\code{lgr::AppenderMemory$clear()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_buffer_size">}\href{../../lgr/html/AppenderMemory.html#method-set_buffer_size}{\code{lgr::AppenderMemory$set_buffer_size()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_on_exit">}\href{../../lgr/html/AppenderMemory.html#method-set_flush_on_exit}{\code{lgr::AppenderMemory$set_flush_on_exit()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_on_rotate">}\href{../../lgr/html/AppenderMemory.html#method-set_flush_on_rotate}{\code{lgr::AppenderMemory$set_flush_on_rotate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_threshold">}\href{../../lgr/html/AppenderMemory.html#method-set_flush_threshold}{\code{lgr::AppenderMemory$set_flush_threshold()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_should_flush">}\href{../../lgr/html/AppenderMemory.html#method-set_should_flush}{\code{lgr::AppenderMemory$set_should_flush()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="show">}\href{../../lgr/html/AppenderMemory.html#method-show}{\code{lgr::AppenderMemory$show()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgrExtra" data-topic="AppenderDigest" data-id="set_subject_layout">}\href{../../lgrExtra/html/AppenderDigest.html#method-set_subject_layout}{\code{lgrExtra::AppenderDigest$set_subject_layout()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgrExtra" data-topic="AppenderMail" data-id="format">}\href{../../lgrExtra/html/AppenderMail.html#method-format}{\code{lgrExtra::AppenderMail$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgrExtra" data-topic="AppenderMail" data-id="set_bcc">}\href{../../lgrExtra/html/AppenderMail.html#method-set_bcc}{\code{lgrExtra::AppenderMail$set_bcc()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgrExtra" data-topic="AppenderMail" data-id="set_cc">}\href{../../lgrExtra/html/AppenderMail.html#method-set_cc}{\code{lgrExtra::AppenderMail$set_cc()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgrExtra" data-topic="AppenderMail" data-id="set_from">}\href{../../lgrExtra/html/AppenderMail.html#method-set_from}{\code{lgrExtra::AppenderMail$set_from()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgrExtra" data-topic="AppenderMail" data-id="set_html">}\href{../../lgrExtra/html/AppenderMail.html#method-set_html}{\code{lgrExtra::AppenderMail$set_html()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgrExtra" data-topic="AppenderMail" data-id="set_to">}\href{../../lgrExtra/html/AppenderMail.html#method-set_to}{\code{lgrExtra::AppenderMail$set_to()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
see \link{AppenderMail} for details
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderSendmail$new(
  to,
  control,
  threshold = NA_integer_,
  flush_threshold = "fatal",
  layout = LayoutFormat$new(fmt = "   \%L [\%t] \%m \%f", timestamp_fmt =
    "\%H:\%M:\%S"),
  subject_layout = LayoutFormat$new(fmt = "[LGR] \%L: \%m"),
  buffer_size = 29,
  from = get_user(),
  cc = NULL,
  bcc = NULL,
  html = FALSE,
  headers = NULL,
  filters = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-flush"></a>}}
\if{latex}{\out{\hypertarget{method-flush}{}}}
\subsection{Method \code{flush()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderSendmail$flush()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_control"></a>}}
\if{latex}{\out{\hypertarget{method-set_control}{}}}
\subsection{Method \code{set_control()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderSendmail$set_control(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_headers"></a>}}
\if{latex}{\out{\hypertarget{method-set_headers}{}}}
\subsection{Method \code{set_headers()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderSendmail$set_headers(x)}\if{html}{\out{</div>}}
}

}
}
