% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_tincanopy.r
\name{grid_tincanopy}
\alias{grid_tincanopy}
\title{Canopy height model based on a triangular irregular network.}
\usage{
grid_tincanopy(.las, res = 0.5, thresholds = c(0, 2, 5, 10, 15),
  max_edge = 0.5)
}
\arguments{
\item{.las}{A LAS object}

\item{res}{numeric resolution}

\item{thresholds}{numeric array. Set of height threholds. If \code{thresholds = 0} the algorithm
is a strict rasterizaton of the triangulation of the first returns. However, if an array is passed to
the function it becomes the Khosravipour et al. pit-free algorithm.}

\item{max_edge}{numeric. Maximum edge-length of a triangle in the Delaunay triangulation
used to constrain the pit-free algorithm (see reference).}
}
\value{
An object of class \code{lasmetrics}
}
\description{
Interpolation of a triangular irregular network constructed from first returns. This function
enables use of the pit-free algorithm developed by Khosravipour et al. (see reference).
}
\examples{
LASfile <- system.file("extdata", "Tree.laz", package="lidR")
las = readLAS(LASfile, Classification = FALSE, Intensity = FALSE, filter = "-drop_z_below 0")

# Basic triangulation and rasterization
chm1 = grid_tincanopy(las, thresholds = 0)

# Khosravipour et al. pitfree algorithm
chm2 = grid_tincanopy(las, thresholds = c(0,2,5,10,15), max_edge = 1)

plot(chm1)
plot(chm2)
}
\references{
Khosravipour, A., Skidmore, A. K., Isenburg, M., Wang, T., & Hussin, Y. A. (2014).
Generating pit-free canopy height models from airborne lidar. Photogrammetric Engineering &
Remote Sensing, 80(9), 863-872.
}
