% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/las_tools.R
\name{las_rescale}
\alias{las_rescale}
\alias{las_reoffset}
\title{Rescale and reoffset a LAS object}
\usage{
las_rescale(las, xscale, yscale, zscale)

las_reoffset(las, xoffset, yoffset, zoffset)
}
\arguments{
\item{las}{An object of class LAS}

\item{xscale, yscale, zscale}{scalar. Can be missing if not relevant.}

\item{xoffset, yoffset, zoffset}{scalar. Can be missing if not relevant.}
}
\description{
Modify the scale factor and the offset of a LAS object. This function modify the header and
recompute the coordinates. Coordinates might be moved by few tenth of millimeters or few
millimeters depending of the accuracy imposed by the user.
}
\examples{
LASfile <- system.file("extdata", "example.laz", package = "rlas")
las <- readLAS(LASfile)

las <- las_rescale(las, xscale = 0.01, yscale = 0.01)
las <- las_reoffset(las, xoffset = 300000, yoffset = 5248000)
}
