% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_is.R
\name{is}
\alias{is}
\alias{is.empty}
\alias{is.overlapping}
\alias{is.indexed}
\alias{is.algorithm}
\alias{is.parallelised}
\title{A set of boolean tests on objects}
\usage{
is.empty(las)

is.overlapping(catalog)

is.indexed(catalog)

is.algorithm(x)

is.parallelised(algorithm)
}
\arguments{
\item{las}{A \code{LAS} object.}

\item{catalog}{A \code{LAScatalog} object.}

\item{x}{Any R object.}

\item{algorithm}{An \code{algorithm} object.}
}
\value{
TRUE or FALSE
}
\description{
\code{is.empty} tests if a \code{LAS} object is a point cloud with 0 points.\cr
\code{is.overlapping} tests if a \code{LAScatalog} has overlapping tiles.\cr
\code{is.indexed} tests if the points of a \code{LAScatalog} are indexed with \code{.lax} files.\cr
\code{is.algorithm} tests if an object is an algorithm of the lidR package.\cr
\code{is.parallelised} tests if an algorithm of the lidR package is natively parallelised with OpenMP.
Returns TRUE if the algorithm is at least partially parallelised i.e. if some portion of the code is
computed in parallel.
}
\examples{
LASfile <- system.file("extdata", "example.laz", package="rlas")
las = readLAS(LASfile)
is.empty(las)

las = new("LAS")
is.empty(las)

f <- lmf(2)
is.parallelised(f)

g <- pitfree()
is.parallelised(g)

ctg <- readLAScatalog(LASfile)
is.indexed(ctg)
}
