% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba.R
\name{iBoxcoxTrBiasCor}
\alias{iBoxcoxTrBiasCor}
\title{Inverse Box-Cox transformation with bias correction}
\usage{
iBoxcoxTrBiasCor(x, lambda, varmod)
}
\arguments{
\item{x}{vector or RasterLayer. values to be transformed}

\item{lambda}{numeric. parameter of Box-Cox transformation}

\item{varmod}{numeric. model residuals variance}
}
\value{
a vector or RasterLayer
}
\description{
Inverse Box-Cox transform with bias correction as suggested by Pu & Tiefelsdorf (2015). Here `varmod` is not the local prediction variance as suggested in the paper but the model residuals variance. For variance computation, use `n-p` instead of `n-1`, with `p` the number of variables in the model.
}
\examples{
x <- 1:10
iBoxcoxTr(x, 0.3)
iBoxcoxTrBiasCor(x, 0.3, 0)
iBoxcoxTrBiasCor(x, 0.3, 2)

# plot functions
curve(iBoxcoxTr(x, 0.3), 0, 3, col = "blue",
main = "inverse Box Cox transf., lambda = 0.3",
xlab = "x", ylab = "inverse Boxcox(x, lambda = 0.3)")
curve(iBoxcoxTrBiasCor(x, 0.3, 1), 0, 3, col = "red", add = TRUE)
curve(iBoxcoxTrBiasCor(x, 0.3, 2), 0, 3,  col = "black", add = TRUE)
legend("topleft", legend = c("residuals variance  = 2",
"residuals variance  = 1", "residuals variance not accounted for"),
col = c("black", "red", "blue"), lty = 1)
}
\references{
Xiaojun Pu and Michael Tiefelsdorf, 2015. A variance-stabilizing transformation to mitigate biased variogram estimation in heterogeneous surfaces with clustered samples. \doi{10.1007/978-3-319-22786-3_24}
}
\seealso{
\code{\link{BoxcoxTr}} Box-Cox transformation, \code{\link{iBoxcoxTr}} inverse Box-Cox transformation.
}
