% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.detection.R
\name{segmentation}
\alias{segmentation}
\title{Image segmentation by seed-based watershed algorithm}
\usage{
segmentation(maxi, dem.nl)
}
\arguments{
\item{maxi}{cimg or rasterLayer object. image with seed points (e.g. from \code{\link{maximaDetection}} or \code{\link{maximaSelection}})}

\item{dem.nl}{cimg or rasterLayer object. image for seed propagation (typically initial image used for maxima detection).}
}
\value{
A cimg object or rasterlayer object with segments id
}
\description{
performs a seed-based watershed segmentation (wrapper for imager::watershed)
}
\examples{
data(chmchablais3)

# median filter
chmchablais3 <- demFiltering(chmchablais3, nlFilter="Median", nlSize=3,
                             sigmap=0)$non.linear.image

# maxima detection
maxi <- maximaDetection(chmchablais3)

# maxima selection
selected.maxi <- maximaSelection(maxi, chmchablais3, dm=1, dprop=0.1)

# segmentation
seg.maxi <- segmentation(maxi, chmchablais3)
seg.selected.maxi <- segmentation(selected.maxi, chmchablais3)

# plot original image
raster::plot(chmchablais3, main="Median filter")

# plot segmented image
# replace segment with id 0 (not a tree) with NA
seg.maxi[seg.maxi==0] <- NA
raster::plot(seg.maxi \%\% 8, main="Segments, no maxima selection", col=rainbow(8))
seg.selected.maxi[seg.selected.maxi==0] <- NA
raster::plot(seg.selected.maxi \%\% 8, main="Segments, maxima selection", col=rainbow(8))

}
\seealso{
\code{\link{maximaDetection}}, \code{\link{maximaSelection}}, \code{\link{segAdjust}}
}
