% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_detection.R
\name{raster_zonal_stats}
\alias{raster_zonal_stats}
\title{Image statistic in segment}
\usage{
raster_zonal_stats(segms, dem_nl, fun = max)
}
\arguments{
\item{segms}{cimg or rasterLayer object. image with segments id (e.g. from 
\code{\link{segmentation}})}

\item{dem_nl}{cimg or rasterLayer object. image to compute statistic from}

\item{fun}{function to compute statistis from values in each segment}
}
\value{
A cimg object or raster object with values of the statistic
}
\description{
compute zonal statistic of an image
}
\examples{
data(chm_chablais3)

# median filter
chm_chablais3 <- dem_filtering(chm_chablais3,
  nl_filter = "Median", nl_size = 3,
  sigmap = 0
)$non_linear_image

# maxima detection
maxi <- maxima_detection(chm_chablais3)

# segmentation
seg_maxi <- segmentation(maxi, chm_chablais3)

# compute image of maximum value in each segment
max_in_segment <- raster_zonal_stats(seg_maxi, chm_chablais3)

# plot original image
raster::plot(chm_chablais3, main = "Median filter")

# plot segments and image of max value inside segments
seg_maxi[seg_maxi == 0] <- NA
raster::plot(seg_maxi \%\% 8, main = "Segments", col = rainbow(8))
raster::plot(max_in_segment, main = "Max value in segment")
}
\seealso{
\code{\link{segmentation}}
}
