% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_detection.R
\name{dem_filtering}
\alias{dem_filtering}
\title{Image pre-processing (non-linear filtering and Gaussian smoothing)}
\usage{
dem_filtering(
  dem,
  nl_filter = "Closing",
  nl_size = 5,
  sigmap = 0.3,
  padding = TRUE
)
}
\arguments{
\item{dem}{cimg object (e.g. obtained with \code{\link[imager]{as.cimg}}) or 
SpatRaster object (e.g. obtained with \code{\link[terra]{rast}})}

\item{nl_filter}{string. type of non-linear filter to apply: "None", "Closing" 
or "Median"}

\item{nl_size}{numeric. kernel width in pixel for non-linear filtering}

\item{sigmap}{numeric or matrix. if a single number is provided, sigmap is 
the standard deviation of the Gaussian filter in pixel, 0 corresponds to no 
smoothing. In case of matrix, the first column corresponds to the standard 
deviation of the filter, and the second to thresholds for image values (e.g. 
a filter of standard deviation specified in line \code{i} is applied to pixels 
in image which values are between thresholds indicated in lines \code{i} and 
\code{i+1}). Threshold values should be ordered in increasing order.}

\item{padding}{boolean. Whether image should be padded by duplicating edge 
values before filtering to avoid border effects}
}
\value{
A list of two cimg objects or a SpatRaster object with image after non-linear 
filter and image after both filters
}
\description{
applies two filters to an image:
\enumerate{
\item A non-linear filter: closing (\code{\link[imager]{mclosing}}) with disk 
kernel, or median (\code{\link[imager]{medianblur}}) with square kernel
\item A 2D Gaussian smoother (The \code{\link[imager]{deriche}} filter is 
applied on both dimensions). Value-dependent smoothing is possible
}
}
\examples{
data(chm_chablais3)
chm_chablais3 <- terra::rast(chm_chablais3)

# filtering with median and Gaussian smoothing
im <- dem_filtering(chm_chablais3, nl_filter = "Median", nl_size = 3, sigmap = 0.8)

# filtering with median filter and value-dependent Gaussian smoothing
# (less smoothing for values between 0 and 15)
im2 <- dem_filtering(chm_chablais3,
  nl_filter = "Median", nl_size = 3,
  sigmap = cbind(c(0.2, 0.8), c(0, 15))
)

# plot original image
terra::plot(chm_chablais3, main = "Initial image")

# plot image after median filter
terra::plot(im$non_linear_image, main = "Median filter")

# plot image after median and Gaussian filters
terra::plot(im$smoothed_image, main = "Smoothed image")

# plot image after median and value-dependent Gaussian filters
terra::plot(im2$smoothed_image, main = "Value-dependent smoothing")
}
\seealso{
\code{\link{maxima_detection}}, filters of imager package: 
\code{\link[imager]{mclosing}}, \code{\link[imager]{medianblur}}, 
\code{\link[imager]{deriche}}
}
