% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyl_summary_aggregated.R
\name{summary.lyl_aggregated}
\alias{summary.lyl_aggregated}
\title{Summarize Life Years Lost at one specific age}
\usage{
\method{summary}{lyl_aggregated}(object, decimals = 2, ...)
}
\arguments{
\item{object}{An object of class \code{lyl_aggregated} (obtained with function
\code{lyl_aggregated} or \code{lyl_aggregated_range}).}

\item{decimals}{Number of decimals to be reported (default is 2).}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
A table with the summary of the results.
}
\description{
\code{summary} for objects of class \code{lyl_aggregated} summarizes Life Years Lost.
}
\examples{
# Load simulated data as example
data(aggreg_data)
data(pop_ref)

# Estimate remaining life expectancy and Life Years
# Lost after age 70 years and before age 90 years
lyl_summary_data70 <- lyl_aggregated(data = aggreg_data, age = age, rates = rate,
                                     data0 = pop_ref, age0 = age, surv0 = survival,
                                     age_specific = 70, tau = 90)

# Summarize and plot the data
summary(lyl_summary_data70)

}
\references{
\itemize{
    \item{Plana-Ripoll et al. lillies – An R package for the estimation of excess Life Years Lost among patients with a given disease or condition.
    \emph{PLoS ONE}. 2020;15(3):e0228073.}
}
}
\seealso{
\itemize{
    \item{\code{\link{lyl_aggregated}} for estimation of Life Years Lost at one specific age.}
    \item{\code{\link{lyl_aggregated_range}} for estimation of Life Years Lost for a range of different ages.}
}
}
