% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{split_on_dim}
\alias{split_on_dim}
\alias{split_on_rows}
\alias{split_on_cols}
\alias{split_along_dim}
\alias{split_along_rows}
\alias{split_along_cols}
\title{Split an array along a dimension}
\usage{
split_on_dim(X, which_dim, f = dimnames(X)[[which_dim]], drop = FALSE,
  depth = Inf)

split_on_rows(X, f = rownames(X), drop = FALSE, depth = Inf)

split_on_cols(X, f = rownames(X), drop = FALSE, depth = Inf)

split_along_dim(X, which_dim, drop = NULL, depth = Inf)

split_along_rows(X, drop = NULL, depth = Inf)

split_along_cols(X, drop = NULL, depth = Inf)
}
\arguments{
\item{X}{an array, or list of arrays. An atomic vector without a dimension
attribute is treated as a 1 dimensional array (Meaning, atomic vectors
without a dim attribute are only accepted if \code{which_dim} is \code{1}. Names of
the passed list are preserved. If a list of arrays, all the arrays must
have the same length of the dimension being split.}

\item{which_dim}{a scalar string or integer, specifying which dimension to
split along. Negative integers count from the back. If a string, it must
refer to a named dimension (e.g, one of \code{names(dimnames(X))}.}

\item{f}{Specify how to split the dimension. \describe{

\item{character, integer, factor}{passed on to \code{base::split()}. Must be the
same length as the dimension being split.}

\item{a list of vectors}{Passed on to \code{base::interaction()} then
\code{base::split()}. Each vector in the list must be the same length as the
dimension being split.}

\item{a scalar integer}{used to split into that many groups of equal size}

\item{a numeric vector where \code{all(f<0)}}{specifies the relative size
proportions of the groups being split. \code{sum(f)} must be \code{1}. For
example \code{c(0.2, 0.2, 0.6)} will return approximately a 20\%-20\%-60\%
split.} }}

\item{drop}{passed on to \code{[}.}

\item{depth}{Scalar number, how many levels to recurse down. Set this if you
want to explicitly treat a list as a vector (that is, a one-dimensional
array). (You can alternatively set dim attributes with \code{dim<-} on the list
to prevent recursion)

\code{split_along_dim(X, which_dim)} is equivalent to \code{split_on_dim(X, which_dim, seq_along_dim(X, which_dim))}.}
}
\value{
A list of arrays, or if a list of arrays was passed in, then a list
of lists of arrays.
}
\description{
Split an array along a dimension
}
\examples{
X <- array(1:8, c(2,3,4))
X
split_along_dim(X, 2)

# specify f as a factor, akin to base::split()
split_on_dim(X, 2, c("a", "a", "b"), drop = FALSE)

d <- c(10, 3, 3)
X <- array(1:prod(d), d)
y <- letters[1:10]
Y <- onehot(y)

# specify `f`` as relative partition sizes
if(require(zeallot) && require(magrittr) && require(purrr)) {

c(train, validate, test) \%<-\% {
  list(X = X, Y = Y, y = y) \%>\%
    shuffle_rows() \%>\%
    split_on_rows(c(0.6, 0.2, 0.2)) \%>\%
    transpose()
}

str(test)
str(train)
str(validate)

}


# with with array data in a data frame by splitting row-wise
if(require(tibble))
  tibble(y, X = split_along_rows(X))
}
