% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLikVector.R
\name{logLikVector}
\alias{logLikVector}
\alias{logLikVector.Bernoulli}
\alias{logLikVector.GP}
\alias{logLik.logLikVector}
\title{Functions for log-likelihood contributions}
\usage{
logLikVector(object, ...)

\method{logLikVector}{Bernoulli}(object, pars = NULL, ...)

\method{logLikVector}{GP}(object, pars = NULL, ...)

\method{logLik}{logLikVector}(object, ...)
}
\arguments{
\item{object}{A fitted model object.}

\item{...}{Further arguments. None are used for either
\code{logLikVector.Bernoulli} or \code{logLikVector.GP}.}

\item{pars}{A numeric parameter vector.

  For \code{logLikVector.Bernoulli} this is a vector of length 1 containing
  a value of the Bernoulli success probability.

  For \code{logLikVector.GP} this is a numeric vector of length 2 containing
  the values of the generalised Pareto scale (\eqn{\sigma_u}) and shape
  (\eqn{\xi}) parameters.}
}
\value{
For \code{logLikVector}: an object of class \code{logLikVec}.
  This is a numeric vector of length \eqn{n} containing contributions to the
  the independence log-likelihood from \eqn{n} observations, with attributes
  \code{"df"} (degrees of freedom), giving the number of estimated
  parameters in the model, and \code{"nobs"}, giving the number observations
  used to perform the estimation.

  For \code{logLik.logLikVector}: an object of class \code{logLik}.  This is
  a number with the attributes \code{"df"} and \code{"nobs"} as described
  above.
}
\description{
Generic function for calculating log-likelihood contributions from
individual observations for a fitted model object.
}
\details{
A \code{logLikVector} method is used to construct a log-likelihood
  function to supply as the argument \code{loglik} to the function
  \code{\link[chandwich]{adjust_loglik}}, which performs log-likelihood
  adjustment for parts 1 and 2 of the inferences performed by
  \code{\link{flite}}.

  The \code{logLik} method \code{logLik.LogLikVector} sums the
  log-likelihood contributions from individual observations.
}
\examples{
# logLikVector.Bernoulli
bfit <- fitBernoulli(c(exdex::cheeseboro) > 45)
bvec <- logLikVector(bfit)
head(bvec)
logLik(bvec)
logLik(bfit)

# estfun.generalisedPareto
gpfit <- fitGP(c(exdex::cheeseboro), u = 45)
gpvec <- logLikVector(gpfit)
head(gpvec)
logLik(gpvec)
logLik(gpfit)
}
\seealso{
\code{\link{Bernoulli}} for maximum likelihood inference for the
  Bernoulli distribution.

\code{\link{generalisedPareto}} for maximum likelihood inference
  for the generalised Pareto distribution.
}
