% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output-fxns.R
\name{steady_state}
\alias{steady_state}
\title{Steady-state estimating from a lit fit object}
\usage{
steady_state(x=NULL, pars=NULL, model=NULL)
}
\arguments{
\item{x}{litfit object}

\item{pars}{(If x not specified) a vector of parameters for the model}

\item{model}{(If x not specified) one of "neg.exp", "weibull", "discrete.parallel",
"discrete series", "cont.quality2"}
}
\value{
steady state values from specified model
}
\description{
Estimate the steady state biomass as a proportion of the annual input,
based on the particular model fit.
}
\details{
Right now only implemented for a subset of models.  More coming soon...
}
\examples{
fit <- fit_litter(time = c(0,1,2,3,4,5,6),mass.remaining = c(1,0.9,1.01,0.4,0.6,0.2,0.01),
'neg.exp',iters = 250)
steady_state(fit)

# no litfit object specified, arbitrary model and parameter values
steady_state(pars = c(6,2), model = "weibull")

}
\seealso{
\code{\link{fit_litter}}
}
\author{
Will Cornwell
}
