<!-- README.md is generated from README.Rmd. Please edit that file -->

# **liver** <a href='https://CRAN.R-project.org/package=liver'><img src='man/figures/logo.png' align="right" height="300" /></a>

![](https://www.r-pkg.org/badges/version/liver) 
![](https://www.r-pkg.org/badges/last-release/liver) 
![](https://cranlogs.r-pkg.org/badges/liver) 
![](https://cranlogs.r-pkg.org/badges/grand-total/liver) 

The `R` package **liver** provides a suite of helper functions and a collection of datasets used in the book [Data Science Foundations and Machine Learning Using R](https://uncovering-data-science.netlify.app). Designed to make data science techniques accessible to individuals with minimal coding experience, it simplifies tasks such as data partitioning for out-of-sample testing and data transformations (z-score and min-max). Inspired by an ancient Persian idiom, the package likens this learning process to "eating the liver of data science," symbolizing deep and immersive engagement with the field. In addition to its helper functions, liver also includes a collection of datasets valuable for multivariate analysis.

## Installation

To install the latest version of this package from [CRAN](https://cran.r-project.org/package=liver), do the following from the R console:

``` r
install.packages("liver")
```

## Loading

``` r
library(liver)
```

## Example for Data Analysis

To see how to use the functionality of the package for data analysis:

- For a simple example see [https://CRAN.R-project.org/package=liver/vignettes/liver-example.html][https://CRAN.R-project.org/package=liver/vignettes/liver-example.html]

- For more examples and details, please refer to the book [Data Science Foundations and Machine Learning Using R](https://uncovering-data-science.netlify.app).