% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{lmls-methods}
\alias{lmls-methods}
\alias{coef.lmls}
\alias{fitted.lmls}
\alias{predict.lmls}
\alias{residuals.lmls}
\alias{vcov.lmls}
\title{Methods for LMLS}
\usage{
\method{coef}{lmls}(object, predictor = c("location", "scale"), ...)

\method{fitted}{lmls}(object, predictor = c("location", "scale"), ...)

\method{predict}{lmls}(
  object,
  newdata = NULL,
  predictor = c("location", "scale"),
  type = c("link", "response"),
  ...
)

\method{residuals}{lmls}(object, type = c("deviance", "pearson", "response"), ...)

\method{vcov}{lmls}(object, predictor = c("location", "scale"), ...)
}
\arguments{
\item{object}{A location-scale regression model from the \code{\link[=lmls]{lmls()}} function.}

\item{predictor}{The predictor to work on. Either \code{"location"} or \code{"scale"}
or both. If both, a list with the names \code{"location"} and
\code{"scale"} is returned.}

\item{...}{Currently ignored.}

\item{newdata}{A data frame (or list or environment) with the covariate
values at which the predictions are computed. If \code{NULL}, the
predictions at the original data are returned.}

\item{type}{Used by \code{predict()} and \code{residuals()}:
\itemize{
\item For \code{predict()}, \code{"link"} or \code{"response"}. If \code{"link"}
(default), \eqn{\mu} and log(\eqn{\sigma}) are returned.
If \code{"response"}, \eqn{\mu} and \eqn{\sigma}
are returned.
\item For \code{residuals()}, \code{"deviance"}, \code{"pearson"} or
\code{"response"}. If \code{"deviance"} (default) or \code{"pearson"},
(\eqn{y - \mu}) / \eqn{\sigma} is returned.
If \code{"response"}, \eqn{y - \mu} is returned.
}}
}
\value{
A numeric vector for \code{residuals()}. For the other methods, a numeric vector
if the argument \code{predictor} is either \code{"location"} or \code{"scale"}, or a list
with the names \code{location} and \code{scale} if it is both.
}
\description{
A couple of methods for location-scale regression models from the \code{\link[=lmls]{lmls()}}
function are provided.
}
