% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predictProbs}
\alias{predictProbs}
\title{Predict expected choice probabilities}
\usage{
predictProbs(
  model,
  alts,
  obsIDName = NULL,
  computeCI = TRUE,
  alpha = 0.025,
  numDraws = 10^4
)
}
\arguments{
\item{model}{The output of a model estimated model using the \code{logitr()}
function.}

\item{alts}{A data frame of a set of alternatives for which to predict
choice probabilities. Each row is an alternative and each column an
attribute corresponding to parameter names in the estimated model.}

\item{obsIDName}{The name of the column that identifies each set of
alternatives. Required if simulating results for more than one set of
alternatives. Defaults to \code{NULL} (for a single set of alternatives).}

\item{computeCI}{Should a confidence interval be computed?
Defaults to \code{TRUE}.}

\item{alpha}{The sensitivity of the computed confidence interval.
Defaults to \code{alpha = 0.025}, reflecting a 95\% CI.}

\item{numDraws}{The number of draws to use in simulating uncertainty
for the computed confidence interval.}
}
\value{
A data frame with the estimated choice probabilities for each
alternative in \code{alts}.
}
\description{
Returns the expected choice probabilities for a single set or multiple sets
of alternatives based on the results from an estimated model.
}
\examples{
\dontrun{
# Run a MNL model in the Preference Space:
library(logitr)

mnl_pref <- logitr(
  data = yogurt,
  choiceName = "choice",
  obsIDName = "obsID",
  parNames = c("price", "feat", "brand")
)

# Create a set of alternatives for which to predict choice probabilities.
# Each row is an alternative and each column an attribute.
# In this example, I just use two of the choice observations from the
# yogurt dataset:
alts <- subset(yogurt, obsID \%in\% c(42, 13),
               select = c('obsID', 'price', 'feat', 'brand'))
alts

# Predict choice probabilities using the estimated preference space MNL
# model:
predictProbs(mnl_pref, alts, obsIDName = "obsID")
}
}
\keyword{logitr}
\keyword{predict}
\keyword{probabilities}
\keyword{simulation}
