% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtp.R
\name{wtp.logitr}
\alias{wtp.logitr}
\title{Get WTP from a preference space model}
\usage{
\method{wtp}{logitr}(object, price)
}
\arguments{
\item{object}{is an object of class \code{logitr} (a model estimated using
the 'logitr()` function).}

\item{price}{The name of the parameter that identifies price.}
}
\value{
A data frame of the WTP estimates.
}
\description{
Returns the computed WTP from a preference space model.
}
\details{
Willingness to pay is computed by dividing the estimated parameters of a
utility model in the "preference" space by the price parameter.
Uncertainty is handled via simulation.
}
\examples{
library(logitr)

# Estimate a preference space model
mnl_pref <- logitr(
  data    = yogurt,
  outcome = "choice",
  obsID   = "obsID",
  pars    = c("price", "feat", "brand")
)

# Compute the WTP implied from the preference space model
wtp(mnl_pref, price = "price")
}
\keyword{logitr}
\keyword{wtp}
