% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doubletruncation.R
\name{nll_ditrunc_elife}
\alias{nll_ditrunc_elife}
\title{Likelihood for doubly interval truncated data}
\usage{
nll_ditrunc_elife(
  par,
  time,
  ltrunc1 = NULL,
  rtrunc1 = NULL,
  ltrunc2 = NULL,
  rtrunc2 = NULL,
  family = c("exp", "gp", "gomp", "gompmake", "weibull", "extgp", "gppiece",
    "extweibull", "perks", "beard", "perksmake", "beardmake"),
  thresh = 0,
  weights = rep(1, length(time)),
  arguments = NULL,
  ...
)
}
\arguments{
\item{par}{vector of parameters}

\item{time}{excess time of the event of follow-up time, depending on the value of event}

\item{ltrunc1}{lower truncation limit, default to \code{NULL}}

\item{rtrunc1}{upper truncation limit, default to \code{NULL}}

\item{ltrunc2}{lower truncation limit, default to \code{NULL}}

\item{rtrunc2}{upper truncation limit, default to \code{NULL}}

\item{family}{string; choice of parametric family, either exponential (\code{exp}), Weibull (\code{weibull}), generalized Pareto (\code{gp}), Gompertz (\code{gomp}), Gompertz-Makeham (\code{gompmake}) or extended generalized Pareto (\code{extgp}).}

\item{thresh}{vector of thresholds}

\item{weights}{weights for observations}

\item{arguments}{a named list specifying default arguments of the function that are common to all \code{elife} calls}

\item{...}{additional arguments for optimization, currently ignored.}
}
\value{
log-likelihood value
}
\description{
Computes the log-likelihood for various parametric models suitable for threshold
exceedances. If threshold is non-zero, then only right-censored, observed event time and interval censored
data whose timing exceeds the thresholds are kept.
}
\keyword{internal}
