% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{test_elife}
\alias{test_elife}
\title{Likelihood ratio test for covariates}
\usage{
test_elife(
  time,
  time2 = NULL,
  event = NULL,
  covariate,
  thresh = 0,
  ltrunc = NULL,
  rtrunc = NULL,
  type = c("right", "left", "interval", "interval2"),
  family = c("exp", "gp", "weibull", "gomp", "gompmake", "extgp", "extweibull", "perks",
    "perksmake", "beard", "beardmake"),
  weights = rep(1, length(time)),
  arguments = NULL,
  ...
)
}
\arguments{
\item{time}{excess time of the event of follow-up time, depending on the value of event}

\item{time2}{ending excess time of the interval for interval censored data only.}

\item{event}{status indicator, normally 0=alive, 1=dead. Other choices are \code{TRUE}/\code{FALSE} (\code{TRUE} for death).
For interval censored data, the status indicator is 0=right censored, 1=event at time, 2=left censored, 3=interval censored.
Although unusual, the event indicator can be omitted, in which case all subjects are assumed to have experienced an event.}

\item{covariate}{vector of factors, logical or integer whose distinct values define groups}

\item{thresh}{vector of thresholds}

\item{ltrunc}{lower truncation limit, default to \code{NULL}}

\item{rtrunc}{upper truncation limit, default to \code{NULL}}

\item{type}{character string specifying the type of censoring. Possible values are "\code{right}", "\code{left}", "\code{interval}", "\code{interval2}".}

\item{family}{string; choice of parametric family}

\item{weights}{weights for observations}

\item{arguments}{a named list specifying default arguments of the function that are common to all \code{elife} calls}

\item{...}{additional arguments for optimization, currently ignored.}
}
\value{
a list with elements
\itemize{
\item \code{stat} likelihood ratio statistic
\item \code{df} degrees of freedom
\item \code{pval} the p-value obtained from the asymptotic chi-square approximation.
}
}
\description{
This function fits separate models for each distinct
value of the factor \code{covariate} and computes a likelihood ratio test
to test whether there are significant differences between
groups.
}
\examples{
test <- with(subset(dutch, ndays > 39082),
 test_elife(
 time = ndays,
 thresh = 39082L,
 covariate = gender,
 ltrunc = ltrunc,
 rtrunc = rtrunc,
 family = "exp"))
 test
}
