% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{pgompmake}
\alias{pgompmake}
\alias{qgompmake}
\alias{dgompmake}
\alias{hgompmake}
\title{Distribution function of the Gompertz-Makeham distribution}
\usage{
pgompmake(
  q,
  scale = 1,
  shape = 0,
  lambda = 0,
  lower.tail = TRUE,
  log.p = FALSE
)

qgompmake(p, scale = 1, shape = 0, lambda = 0, lower.tail = TRUE)

dgompmake(x, scale = 1, shape = 0, lambda = 0, log = FALSE)

hgompmake(x, scale = 1, shape = 0, lambda = 0, log = FALSE)
}
\arguments{
\item{q}{vector of quantiles.}

\item{scale}{scale parameter, strictly positive.}

\item{shape}{shape parameter.}

\item{lambda}{exponential rate}

\item{lower.tail}{logical; if \code{TRUE} (default), the lower tail probability \eqn{\Pr(X \leq x)} is returned.}

\item{log.p}{logical; if \code{FALSE} (default), values are returned on the probability scale.}

\item{p}{vector of probabilities.}

\item{x}{vector of quantiles.}

\item{log}{logical; if \code{TRUE}, return the log hazard}
}
\value{
a vector of (log)-probabilities of the same length as \code{q}

a vector of quantiles

a vector of density

a vector of (log)-hazard.
}
\description{
Distribution function of the Gompertz-Makeham distribution

Quantile function of the Gompertz-Makeham distribution

Density function of the Gompertz-Makeham distribution

Hazard function of the Gompertz-Makeham distribution
}
\note{
The quantile function is defined in terms of Lambert's W function. Particular parameter combinations (small values of \code{lambda} lead to numerical overflow; the function throws a warning when this happens.
}
\keyword{internal}
