% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup.R
\name{vlookup}
\alias{vlookup}
\title{Lookup items in key-value dataframe similar to Excel's vlookup function}
\usage{
vlookup(x, data, key, value, nomatch = NA)
}
\arguments{
\item{x}{Vector of items to lookup in key-value pairs.}

\item{data}{Dataframe containing key-value columns.}

\item{key}{Vector of keys that are searched.}

\item{value}{Vector of values to be returned.}

\item{nomatch}{The value to be returned in the case when no match is
found. Note that it is coerced to integer.}
}
\value{
A vector the same length as \code{x}, but containing the values
of \code{value}.  If \code{x[i]} is equal to \code{key[j]}, then the
value returned in the ith position of the vector is \code{value[j]}.
If no match is found, \code{NA} is returned.
}
\description{
This is a simple wrapper to the \code{match} function.
}
\details{
Search for elements of \code{x} in dataframe \code{data},
column \code{key}, and return the corresponding element of column
\code{value}.
If no match is found, return \code{nomatch}.
}
\examples{
# Example 1.  A and B have different factor levels
A <- factor(c("A","E","F"))
dat <- data.frame(trt = factor(c("E","F","G")),
                  val = c(4,2,0))
vlookup(A,dat, "trt", "val")

}
\author{
Kevin Wright
}
