% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loon2ggplot.R, R/loon2ggplot_l_compound.R,
%   R/loon2ggplot_l_layer_graph.R, R/loon2ggplot_l_layer_histogram.R,
%   R/loon2ggplot_l_layer_scatterplot.R, R/loon2ggplot_l_pairs.R,
%   R/loon2ggplot_l_serialaxes.R, R/loon2ggplot_l_ts.R
\name{loon2ggplot}
\alias{loon2ggplot}
\alias{loon2ggplot.default}
\alias{loon2ggplot.l_plot}
\alias{loon2ggplot.l_hist}
\alias{loon2ggplot.l_plot3D}
\alias{loon2ggplot.l_compound}
\alias{loon2ggplot.l_layer_graph}
\alias{loon2ggplot.l_layer_histogram}
\alias{loon2ggplot.l_layer_scatterplot}
\alias{loon2ggplot.l_pairs}
\alias{loon2ggplot.l_serialaxes}
\alias{loon2ggplot.l_ts}
\title{\code{loon} to \code{ggplot}}
\usage{
loon2ggplot(target, ...)

\method{loon2ggplot}{default}(target, ...)

\method{loon2ggplot}{l_plot}(target, ...)

\method{loon2ggplot}{l_hist}(target, ...)

\method{loon2ggplot}{l_plot3D}(target, ...)

\method{loon2ggplot}{l_compound}(target, ...)

\method{loon2ggplot}{l_layer_graph}(target, ...)

\method{loon2ggplot}{l_layer_histogram}(target, ...)

\method{loon2ggplot}{l_layer_scatterplot}(target, ...)

\method{loon2ggplot}{l_pairs}(target, ...)

\method{loon2ggplot}{l_serialaxes}(target, ...)

\method{loon2ggplot}{l_ts}(target, ...)
}
\arguments{
\item{target}{a\code{loon} or a vector that specifies the
widget, layer, glyph, navigator or context completely.
The widget is specified by the widget path name (e.g. '.l0.plot'),
the remaining objects by their ids.}

\item{...}{arguments used inside \code{loon2ggplot()}, not used by this method}
}
\value{
a \code{ggplot} object
}
\description{
Create a \code{ggplot} object from a \code{loon} widget
}
\examples{
if(interactive()) {
  l <- l_plot(iris, color = iris$Species)
  p <- loon2ggplot(l)
  p # a ggplot object
  str(p)
  # add themes
  p + geom_smooth() + theme_linedraw()
}

}
