% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_aspect.R
\name{l_aspect<-}
\alias{l_aspect<-}
\title{Set the aspect ratio of a plot}
\usage{
l_aspect(widget) <- value
}
\arguments{
\item{widget}{widget path as a string or as an object handle}

\item{value}{aspect ratio}
}
\description{
The aspect ratio is defined by the ratio of the number of pixels
  for one data unit on the y axis and the number of pixels for one data unit
  on the x axes.
}
\details{
Changing the aspect ratio with \code{l_aspect<-} changes effectively
  the \code{zoomY} state to obtain the desired aspect ratio. Note that the 
  aspect ratio in loon depends on the plot width, plot height and the states 
  \code{zoomX}, \code{zoomY}, \code{deltaX}, \code{deltaY} and 
  \code{swapAxes}. Hence, the aspect aspect ratio can not be set permanently
  for a loon plot.
}
\examples{
p <- with(iris, l_plot(Sepal.Length ~ Sepal.Width, color=Species))

l_aspect(p)
l_aspect(p) <- 1
}
