% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_predict.R
\name{l_predict}
\alias{l_predict}
\alias{l_predict.default}
\alias{l_predict.lm}
\alias{l_predict.nls}
\alias{l_predict.glm}
\alias{l_predict.loess}
\title{Model Prediction}
\usage{
l_predict(model, ...)

\method{l_predict}{default}(model, ...)

\method{l_predict}{lm}(
  model,
  newdata = NULL,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  ...
)

\method{l_predict}{nls}(
  model,
  newdata = NULL,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  ...
)

\method{l_predict}{glm}(
  model,
  newdata = NULL,
  interval = c("none", "confidence"),
  level = 0.95,
  ...
)

\method{l_predict}{loess}(
  model,
  newdata = NULL,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  ...
)
}
\arguments{
\item{model}{a model object for which prediction is desired}

\item{...}{arguments passed in \code{predict}}

\item{newdata}{optionally, a data frame in which to look for variables with which to predict.
If omitted, the fitted linear predictors are used.}

\item{interval}{type of interval, could be "none", "confidence" or "prediction" (not for \code{glm})}

\item{level}{confidence level}
}
\value{
A data frame is returned with \code{x} (if \code{newdata} is given) and \code{y}.
If the \code{interval} is not \code{none},
two more columns, \code{lower} (lower interval) and \code{upper} (upper interval) will be returned.
}
\description{
It is entirely for the purpose of plotting fits and intervals on a scatterplot (or histogram).
It is a generic function to predict models for \code{loon} smooth layer (a wrap of the function \code{predict}).
However, the output is unified.
}
\examples{
y <- rnorm(10)
x <- rnorm(10)
model1 <- lm(y ~ x)
# formal output
pre <- l_predict(model1, newdata = data.frame(x = sort(x)),
                 interval = "conf")
head(pre)

if(interactive()) {
p <- with(cars, l_plot(speed, dist))

# Example taken from
# https://stackoverflow.com/questions/23852505/how-to-get-confidence-interval-for-smooth-spline
#
l_predict.smooth.spline <- function(model, interval = c("confidence", "none"),
                                    level = 0.95, ...) {
# confidence interval of `smooth.spline`
  interval <- match.arg(interval)

  res <- (model$yin - model$y)/(1 - model$lev)     # jackknife residuals
  sigma <- sqrt(var(res))                          # estimate sd
  std <- stats::qnorm(level / 2 + 0.5)
  upper <- model$y + std * sigma * sqrt(model$lev) # upper 95\% conf. band
  lower <- model$y - std * sigma * sqrt(model$lev) # lower 95\% conf. band

  data.frame(y = model$yin, lower = lower, upper = upper)
}
l <- l_layer_smooth(p, method = "smooth.spline", interval = "confidence")
}

}
