% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_ng_plots.R
\name{l_ng_plots.default}
\alias{l_ng_plots.default}
\title{Select 2d spaces with variable associated measures displayed in
  scatterplot matrix}
\usage{
\method{l_ng_plots}{default}(measures, data, separator = ":", ...)
}
\arguments{
\item{measures}{matrix or data.frame with measures (columns) for variable
pairs (rows) and rownames of the two variates separated by separator}

\item{data}{data frame for scatterplot}

\item{separator}{a string that separates the variable pair string into the
individual variables}

\item{...}{arguments passed on to configure the scatterplot}
}
\value{
named list with plots-, graph-, plot-, navigator-, and context 
  handle. The list also contains the environment of the the function call in 
  \code{env}.
}
\description{
Measures object is a matrix or data.frame with measures
  (columns) for variable pairs (rows) and rownames of the two variates
  separated by separator
}
\details{
For more information run: \code{l_help("learn_R_display_graph.html#l_ng_plots")}
}
\examples{

if(interactive()){

\dontrun{
n <- 100
dat <- data.frame(
   A = rnorm(n), B = rnorm(n), C = rnorm(n),
   D = rnorm(n), E = rnorm(n)
)
m2d <- data.frame(
    cov = with(dat, c(cov(A,B), cov(A,C), cov(B,D), cov(D,E), cov(A,E))),
    measure_1 = c(1, 3, 2, 1, 4),
    row.names = c('A:B', 'A:C', 'B:D', 'D:E', 'A:E')
)

# or m2d <- as.matrix(m2d)

nav <- l_ng_plots(measures=m2d, data=dat)

# only one measure
m <- m2d[,1]
names(m) <- row.names(m2d)
nav <- l_ng_plots(measures=m, data=dat)

m2d[c(1,2),1]

# one d measures
m1d <- data.frame(
     mean = sapply(dat, mean),
     median =  sapply(dat, median),
     sd =  sapply(dat, sd),
     q1 = sapply(dat, function(x)quantile(x, probs=0.25)),
     q3 = sapply(dat, function(x)quantile(x, probs=0.75)),
     row.names = names(dat)
)

nav <- l_ng_plots(m1d, dat)

## more involved
q1 <- function(x)as.vector(quantile(x, probs=0.25))

# be careful that the vector names are correct
nav <- l_ng_plots(sapply(oliveAcids, q1), oliveAcids)
}

}

}
\seealso{
\code{\link{l_ng_plots}}, \code{\link{l_ng_plots.measures}},
  \code{\link{l_ng_plots.scagnostics}}, \code{\link{measures1d}},
  \code{\link{measures2d}}, \code{\link{scagnostics2d}},
  \code{\link{l_ng_ranges}}
}
